/*
 * Decompiled with CFR 0.152.
 */
package org.staxnav;

import javax.xml.namespace.QName;
import org.staxnav.EnumElement;
import org.staxnav.Naming;
import org.staxnav.StaxNavigator;
import org.staxnav.StaxNavigatorTestCase;

public class NamespaceTestCase
extends StaxNavigatorTestCase {
    public void testA() throws Exception {
        StaxNavigator navigator = this.navigator(new Naming.Local(), "namespace1.xml");
        NamespaceTestCase.assertEquals((String)"foo", (String)((String)navigator.getName()));
        NamespaceTestCase.assertEquals((String)"http://www.w3.org/TR/html4/", (String)navigator.getNamespaceByPrefix(""));
        NamespaceTestCase.assertEquals(null, (String)navigator.getNamespaceByPrefix("ns"));
        NamespaceTestCase.assertEquals((String)"bar", (String)((String)navigator.next()));
        NamespaceTestCase.assertEquals((String)"http://www.w3.org/TR/html4/", (String)navigator.getNamespaceByPrefix(""));
        NamespaceTestCase.assertEquals(null, (String)navigator.getNamespaceByPrefix("ns"));
    }

    public void testB() throws Exception {
        StaxNavigator navigator = this.navigator(new Naming.Local(), "namespace2.xml");
        NamespaceTestCase.assertEquals((String)"foo", (String)((String)navigator.getName()));
        NamespaceTestCase.assertEquals((String)"http://www.w3.org/TR/html4/", (String)navigator.getNamespaceByPrefix("ns"));
        NamespaceTestCase.assertEquals((String)"bar", (String)((String)navigator.next()));
        NamespaceTestCase.assertEquals((String)"http://www.w3.org/2000/svg", (String)navigator.getNamespaceByPrefix("ns"));
        NamespaceTestCase.assertEquals((String)"juu", (String)((String)navigator.next()));
        NamespaceTestCase.assertEquals((String)"http://www.w3.org/2000/svg", (String)navigator.getNamespaceByPrefix("ns"));
    }

    public void testC() throws Exception {
        StaxNavigator navigator = this.navigator(new Naming.Enumerated.Mapped(Name.class, (Enum)Name.NOT_FOUND), "namespace1.xml");
        NamespaceTestCase.assertEquals((Object)((Object)Name.FOO), (Object)navigator.getName());
        NamespaceTestCase.assertEquals((boolean)true, (boolean)navigator.next((Object)Name.BAR));
        NamespaceTestCase.assertEquals((Object)((Object)Name.NOT_FOUND), (Object)navigator.next());
    }

    public void testD() throws Exception {
        StaxNavigator navigator = this.navigator(new Naming.Local(), "namespace1.xml");
        NamespaceTestCase.assertEquals((String)"foo", (String)((String)navigator.getName()));
        NamespaceTestCase.assertEquals((boolean)true, (boolean)navigator.next((Object)"bar"));
    }

    public void testE() throws Exception {
        StaxNavigator navigator = this.navigator(new Naming.Local(), "namespace3.xml");
        NamespaceTestCase.assertEquals((String)"foo", (String)((String)navigator.getName()));
        NamespaceTestCase.assertEquals((boolean)true, (boolean)navigator.next((Object)"bar"));
        NamespaceTestCase.assertEquals((String)"juu_value", (String)navigator.getAttribute("juu"));
        NamespaceTestCase.assertEquals((String)"juu_value", (String)navigator.getAttribute(new QName("", "juu")));
        NamespaceTestCase.assertEquals((String)"ns_juu_value", (String)navigator.getAttribute(new QName("http://www.w3.org/2000/svg", "juu")));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Name implements EnumElement<Name>
    {
        FOO("foo"),
        BAR("bar"),
        JUU("juu"),
        NOT_FOUND(null);

        private String localName;

        private Name(String localName) {
            this.localName = localName;
        }

        public String getLocalName() {
            return this.localName;
        }
    }
}

