/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.r2dbc;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.testcontainers.r2dbc.EmptySubscription;

class ConnectionPublisher
implements Publisher<Connection> {
    private final Supplier<CompletableFuture<ConnectionFactory>> futureSupplier;

    ConnectionPublisher(Supplier<CompletableFuture<ConnectionFactory>> futureSupplier) {
        this.futureSupplier = futureSupplier;
    }

    public void subscribe(Subscriber<? super Connection> actual) {
        actual.onSubscribe((Subscription)new StateMachineSubscription(actual));
    }

    private class StateMachineSubscription
    implements Subscription {
        private final Subscriber<? super Connection> actual;
        Subscription subscriptionState;

        StateMachineSubscription(Subscriber<? super Connection> actual) {
            this.actual = actual;
            this.subscriptionState = new WaitRequestSubscriptionState();
        }

        public synchronized void request(long n) {
            this.subscriptionState.request(n);
        }

        public synchronized void cancel() {
            this.subscriptionState.cancel();
        }

        synchronized void transitionTo(SubscriptionState newState) {
            this.subscriptionState = newState;
            newState.enter();
        }

        class WaitRequestSubscriptionState
        extends SubscriptionState {
            WaitRequestSubscriptionState() {
            }

            public void request(long n) {
                StateMachineSubscription.this.transitionTo(new WaitFutureCompletionSubscriptionState());
            }

            public void cancel() {
            }
        }

        abstract class SubscriptionState
        implements Subscription {
            SubscriptionState() {
            }

            void enter() {
            }
        }

        class ProxySubscriptionState
        extends SubscriptionState
        implements Subscriber<Connection> {
            private final Publisher<? extends Connection> publisher;
            private Subscription s;
            private boolean cancelled = false;

            ProxySubscriptionState(Publisher<? extends Connection> publisher) {
                this.publisher = publisher;
            }

            @Override
            void enter() {
                this.publisher.subscribe((Subscriber)this);
            }

            public void request(long n) {
            }

            public synchronized void cancel() {
                this.cancelled = true;
                if (this.s != null) {
                    this.s.cancel();
                }
            }

            public synchronized void onSubscribe(Subscription s) {
                this.s = s;
                if (!this.cancelled) {
                    s.request(1L);
                } else {
                    s.cancel();
                }
            }

            public void onNext(Connection connection) {
                StateMachineSubscription.this.actual.onNext((Object)connection);
            }

            public void onError(Throwable t) {
                StateMachineSubscription.this.actual.onError(t);
            }

            public void onComplete() {
                StateMachineSubscription.this.actual.onComplete();
            }
        }

        class WaitFutureCompletionSubscriptionState
        extends SubscriptionState {
            private CompletableFuture<ConnectionFactory> future;

            WaitFutureCompletionSubscriptionState() {
            }

            @Override
            void enter() {
                this.future = (CompletableFuture)ConnectionPublisher.this.futureSupplier.get();
                this.future.whenComplete((connectionFactory, e) -> {
                    if (e != null) {
                        StateMachineSubscription.this.actual.onSubscribe((Subscription)EmptySubscription.INSTANCE);
                        StateMachineSubscription.this.actual.onError(e);
                        return;
                    }
                    Publisher publisher = connectionFactory.create();
                    StateMachineSubscription.this.transitionTo(new ProxySubscriptionState((Publisher<? extends Connection>)publisher));
                });
            }

            public void request(long n) {
            }

            public void cancel() {
                this.future.cancel(true);
            }
        }
    }
}

