/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.jooq.codegen.datasource;

import java.sql.Driver;
import java.util.Objects;
import java.util.function.Predicate;
import org.jooq.meta.jaxb.Jdbc;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.jooq.codegen.database.DatabaseProps;
import org.testcontainers.jooq.codegen.database.DatabaseProvider;
import org.testcontainers.jooq.codegen.datasource.ContainerTargetDatasource;
import org.testcontainers.jooq.codegen.datasource.ExistingTargetDatasource;
import org.testcontainers.jooq.codegen.jooq.JooqProps;

public interface TargetDatasource
extends AutoCloseable {
    public static TargetDatasource createOrJoinExisting(JooqProps jooq, DatabaseProps database) {
        if (TargetDatasource.needSpinContainer(jooq)) {
            JdbcDatabaseContainer<?> databaseContainer = DatabaseProvider.getDatabaseContainer(database);
            return new ContainerTargetDatasource(databaseContainer);
        }
        return new ExistingTargetDatasource(jooq.getJdbc());
    }

    private static boolean needSpinContainer(JooqProps jooq) {
        Jdbc jdbc = jooq.getJdbc();
        return ((Predicate<Jdbc>)Objects::isNull).or(props -> props.getUrl() == null).or(props -> props.getUser() == null).or(props -> props.getPassword() == null).test(jdbc);
    }

    public String getUrl();

    public String getUsername();

    public String getPassword();

    public Driver getDriverInstance();
}

