/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.jooq.codegen.migration.runner;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.output.MigrateResult;
import org.testcontainers.jooq.codegen.migration.runner.MigrationRunner;
import org.testcontainers.jooq.codegen.migration.runner.RunnerProperties;

public class FlywayRunner
extends HashMap<String, String>
implements MigrationRunner {
    @Override
    public String put(String key, String value) {
        String prefixKey = this.addFlywayPrefix(key);
        return super.put(prefixKey, value);
    }

    @Override
    public void run(RunnerProperties runnerProperties) {
        Log log = runnerProperties.log();
        this.put("flyway.url", runnerProperties.getUrl());
        this.put("flyway.user", runnerProperties.getUsername());
        this.put("flyway.password", runnerProperties.getPassword());
        FluentConfiguration configuration = new FluentConfiguration().loadDefaultConfigurationFiles();
        this.addDefaults(runnerProperties);
        configuration.configuration((Map)this);
        Flyway flyway = configuration.load();
        MigrateResult result = flyway.migrate();
        String message = result.migrationsExecuted > 0 ? "Applied %s flyway migrations".formatted(result.migrationsExecuted) : "No flyway migrations were applied";
        log.info((CharSequence)message);
    }

    private void addDefaults(RunnerProperties runnerProperties) {
        String defaultResourceLocation = "%s%s/src/main/resources/db/migration".formatted("filesystem:", runnerProperties.mavenProject().getBasedir().getAbsolutePath());
        String defaultClasspathLocation = "%s%s".formatted("classpath:", "/db/migration");
        this.putIfAbsent("flyway.locations", "%s,%s".formatted(defaultResourceLocation, defaultClasspathLocation));
    }

    private String addFlywayPrefix(String key) {
        return key.startsWith("flyway.") ? key : "flyway." + key;
    }
}

