/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.strategy.YugabyteDBYSQLWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.utility.DockerImageName;

public class YugabyteDBYSQLContainer
extends JdbcDatabaseContainer<YugabyteDBYSQLContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"yugabytedb/yugabyte");
    private static final Integer YSQL_PORT = 5433;
    private static final Integer MASTER_DASHBOARD_PORT = 7000;
    private static final Integer TSERVER_DASHBOARD_PORT = 9000;
    private static final String JDBC_DRIVER_CLASS = "com.yugabyte.Driver";
    private static final String JDBC_CONNECT_PREFIX = "jdbc:yugabytedb";
    private static final String ENTRYPOINT = "bin/yugabyted start --background=false";
    private String database = "yugabyte";
    private String username = "yugabyte";
    private String password = "yugabyte";

    public YugabyteDBYSQLContainer(String imageName) {
        this(DockerImageName.parse((String)imageName));
    }

    public YugabyteDBYSQLContainer(DockerImageName imageName) {
        super(imageName);
        imageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{YSQL_PORT, MASTER_DASHBOARD_PORT, TSERVER_DASHBOARD_PORT});
        this.waitingFor(new YugabyteDBYSQLWaitStrategy((WaitStrategyTarget)this).withStartupTimeout(Duration.ofSeconds(60L)));
        this.withCommand(ENTRYPOINT);
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return Collections.singleton(this.getMappedPort(YSQL_PORT));
    }

    protected void configure() {
        this.addEnv("YSQL_DB", this.database);
        this.addEnv("YSQL_USER", this.username);
        this.addEnv("YSQL_PASSWORD", this.password);
    }

    public String getDriverClassName() {
        return JDBC_DRIVER_CLASS;
    }

    public String getJdbcUrl() {
        return "jdbc:yugabytedb://" + this.getHost() + ":" + this.getMappedPort(YSQL_PORT) + "/" + this.database + this.constructUrlParameters("?", "&");
    }

    public String getDatabaseName() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }

    public YugabyteDBYSQLContainer withDatabaseName(String database) {
        this.database = database;
        return this;
    }

    public YugabyteDBYSQLContainer withUsername(String username) {
        this.username = username;
        return this;
    }

    public YugabyteDBYSQLContainer withPassword(String password) {
        this.password = password;
        return this;
    }

    protected void waitUntilContainerStarted() {
        this.getWaitStrategy().waitUntilReady((WaitStrategyTarget)this);
    }
}

