/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.api;

import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.testfx.api.FxToolkitContext;
import org.testfx.internal.JavaVersionAdapter;
import org.testfx.toolkit.ApplicationLauncher;
import org.testfx.toolkit.ApplicationService;
import org.testfx.toolkit.ToolkitService;
import org.testfx.toolkit.impl.ApplicationLauncherImpl;
import org.testfx.toolkit.impl.ApplicationServiceImpl;
import org.testfx.toolkit.impl.ToolkitServiceImpl;
import org.testfx.util.WaitForAsyncUtils;

public final class FxToolkit {
    private static final ApplicationLauncher APP_LAUNCHER = new ApplicationLauncherImpl();
    private static final ApplicationService APP_SERVICE = new ApplicationServiceImpl();
    private static final FxToolkitContext CONTEXT = new FxToolkitContext();
    private static final ToolkitService SERVICE = new ToolkitServiceImpl(APP_LAUNCHER, APP_SERVICE);

    private FxToolkit() {
    }

    public static Stage registerPrimaryStage() throws TimeoutException {
        Stage primaryStage = WaitForAsyncUtils.waitFor(CONTEXT.getLaunchTimeoutInMillis(), TimeUnit.MILLISECONDS, SERVICE.setupPrimaryStage(CONTEXT.getPrimaryStageFuture(), CONTEXT.getApplicationClass(), CONTEXT.getApplicationArgs()));
        CONTEXT.setRegisteredStage(primaryStage);
        Platform.setImplicitExit((boolean)false);
        return primaryStage;
    }

    public static Stage registerStage(Supplier<Stage> stageSupplier) throws TimeoutException {
        Stage stage = FxToolkit.setupFixture(stageSupplier::get);
        CONTEXT.setRegisteredStage(stage);
        return stage;
    }

    public static Stage setupStage(Consumer<Stage> stageConsumer) throws TimeoutException {
        return FxToolkit.waitForSetup(SERVICE.setupStage(CONTEXT.getRegisteredStage(), stageConsumer));
    }

    public static Application setupApplication(Class<? extends Application> applicationClass, String ... applicationArgs) throws TimeoutException {
        return FxToolkit.waitForSetup(SERVICE.setupApplication(CONTEXT::getRegisteredStage, applicationClass, applicationArgs));
    }

    public static Application setupApplication(Supplier<Application> applicationSupplier) throws TimeoutException {
        return FxToolkit.waitForSetup(SERVICE.setupApplication(CONTEXT::getRegisteredStage, applicationSupplier, new String[0]));
    }

    public static void cleanupApplication(Application application) throws TimeoutException {
        if (!FxToolkit.isFXApplicationThreadRunning()) {
            throw new TimeoutException("FX Application Thread not running");
        }
        FxToolkit.waitForSetup(SERVICE.cleanupApplication(application));
    }

    public static Scene setupScene(Supplier<Scene> sceneSupplier) throws TimeoutException {
        return FxToolkit.waitForSetup(SERVICE.setupScene(CONTEXT.getRegisteredStage(), sceneSupplier));
    }

    public static Parent setupSceneRoot(Supplier<Parent> sceneRootSupplier) throws TimeoutException {
        return FxToolkit.waitForSetup(SERVICE.setupSceneRoot(CONTEXT.getRegisteredStage(), sceneRootSupplier));
    }

    public static void setupFixture(Runnable runnable) throws TimeoutException {
        FxToolkit.waitForSetup(SERVICE.setupFixture(runnable));
    }

    public static <T> T setupFixture(Callable<T> callable) throws TimeoutException {
        return FxToolkit.waitForSetup(SERVICE.setupFixture(callable));
    }

    public static void showStage() throws TimeoutException {
        FxToolkit.setupStage(stage -> {
            stage.show();
            stage.toBack();
            stage.toFront();
        });
    }

    public static void hideStage() throws TimeoutException {
        FxToolkit.setupStage(Window::hide);
    }

    public static void cleanupStages() throws TimeoutException {
        FxToolkit.setupFixture(() -> JavaVersionAdapter.getWindows().forEach(Window::hide));
    }

    public static FxToolkitContext toolkitContext() {
        return CONTEXT;
    }

    private static <T> T waitForSetup(Future<T> future) throws TimeoutException {
        T ret = WaitForAsyncUtils.waitFor(CONTEXT.getSetupTimeoutInMillis(), TimeUnit.MILLISECONDS, future);
        WaitForAsyncUtils.waitForFxEvents();
        return ret;
    }

    public static boolean isFXApplicationThreadRunning() {
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        for (Thread thread : threads) {
            if (!thread.getName().equals("JavaFX Application Thread")) continue;
            return true;
        }
        return false;
    }
}

