/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.matcher.base;

import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.hamcrest.Matcher;
import org.testfx.matcher.base.GeneralMatchers;

public class ParentMatchers {
    private ParentMatchers() {
    }

    public static Matcher<Parent> hasChild() {
        String descriptionText = "has at least one child";
        return GeneralMatchers.typeSafeMatcher(Parent.class, descriptionText, parent -> ParentMatchers.toText((ObservableList<Node>)parent.getChildrenUnmodifiable()), parent -> !parent.getChildrenUnmodifiable().isEmpty());
    }

    public static Matcher<Parent> hasChildren(int amount) {
        String descriptionText = "has exactly " + amount + " children";
        return GeneralMatchers.typeSafeMatcher(Parent.class, descriptionText, parent -> ParentMatchers.toText((ObservableList<Node>)parent.getChildrenUnmodifiable()), parent -> parent.getChildrenUnmodifiable().size() == amount);
    }

    private static String toText(ObservableList<Node> children) {
        if (children.isEmpty()) {
            return "empty (contained no children)";
        }
        return '[' + children.stream().map(node -> node.getClass().getSimpleName()).collect(Collectors.joining(", ")) + ']' + " (which has " + children.size() + ' ' + (children.size() == 1 ? "child" : "children") + ')';
    }
}

