/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.robot.impl;

import java.util.Objects;
import javafx.scene.input.MouseButton;
import org.testfx.robot.ClickRobot;
import org.testfx.robot.Motion;
import org.testfx.robot.MouseRobot;
import org.testfx.robot.MoveRobot;
import org.testfx.robot.SleepRobot;
import org.testfx.service.query.PointQuery;

public class ClickRobotImpl
implements ClickRobot {
    private static final long SLEEP_AFTER_DOUBLE_CLICK_IN_MILLIS = 50L;
    private final MouseRobot mouseRobot;
    private final MoveRobot moveRobot;
    private final SleepRobot sleepRobot;

    public ClickRobotImpl(MouseRobot mouseRobot, MoveRobot moveRobot, SleepRobot sleepRobot) {
        Objects.requireNonNull(mouseRobot, "mouseRobot must not be null");
        Objects.requireNonNull(moveRobot, "moveRobot must not be null");
        Objects.requireNonNull(sleepRobot, "sleepRobot must not be null");
        this.mouseRobot = mouseRobot;
        this.moveRobot = moveRobot;
        this.sleepRobot = sleepRobot;
    }

    @Override
    public void clickOn(MouseButton ... buttons) {
        this.mouseRobot.pressNoWait(buttons);
        this.mouseRobot.release(buttons);
    }

    @Override
    public void clickOn(PointQuery pointQuery, Motion motion, MouseButton ... buttons) {
        this.moveRobot.moveTo(pointQuery, motion);
        this.clickOn(buttons);
    }

    @Override
    public void doubleClickOn(MouseButton ... buttons) {
        this.clickOn(buttons);
        this.clickOn(buttons);
        this.sleepRobot.sleep(50L);
    }

    @Override
    public void doubleClickOn(PointQuery pointQuery, Motion motion, MouseButton ... buttons) {
        this.moveRobot.moveTo(pointQuery, motion);
        this.clickOn(buttons);
        this.clickOn(buttons);
        this.sleepRobot.sleep(50L);
    }
}

