/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.robot.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javafx.geometry.Point2D;
import javafx.scene.input.MouseButton;
import org.testfx.robot.BaseRobot;
import org.testfx.robot.MouseRobot;
import org.testfx.util.WaitForAsyncUtils;

public class MouseRobotImpl
implements MouseRobot {
    private final BaseRobot baseRobot;
    private final Set<MouseButton> pressedButtons = new HashSet<MouseButton>();

    public MouseRobotImpl(BaseRobot baseRobot) {
        Objects.requireNonNull(baseRobot, "baseRobot must not be null");
        this.baseRobot = baseRobot;
    }

    @Override
    public void press(MouseButton ... buttons) {
        this.pressNoWait(buttons);
        WaitForAsyncUtils.waitForFxEvents();
    }

    @Override
    public void pressNoWait(MouseButton ... buttons) {
        if (buttons.length == 0) {
            this.pressButton(MouseButton.PRIMARY);
        } else {
            Arrays.asList(buttons).forEach(this::pressButton);
        }
    }

    @Override
    public void release(MouseButton ... buttons) {
        this.releaseNoWait(buttons);
        WaitForAsyncUtils.waitForFxEvents();
    }

    @Override
    public void releaseNoWait(MouseButton ... buttons) {
        if (buttons.length == 0) {
            new ArrayList<MouseButton>(this.pressedButtons).forEach(this::releaseButton);
        } else {
            Arrays.asList(buttons).forEach(this::releaseButton);
        }
    }

    @Override
    public void move(Point2D location) {
        this.moveNoWait(location);
        WaitForAsyncUtils.waitForFxEvents();
    }

    @Override
    public void moveNoWait(Point2D location) {
        this.baseRobot.moveMouse(location);
    }

    @Override
    public void scroll(int wheelAmount) {
        this.scrollNoWait(wheelAmount);
        WaitForAsyncUtils.waitForFxEvents();
    }

    @Override
    public void scrollNoWait(int wheelAmount) {
        this.baseRobot.scrollMouse(wheelAmount);
    }

    @Override
    public final Set<MouseButton> getPressedButtons() {
        return Collections.unmodifiableSet(this.pressedButtons);
    }

    private void pressButton(MouseButton button) {
        if (this.pressedButtons.add(button)) {
            this.baseRobot.pressMouse(button);
        }
    }

    private void releaseButton(MouseButton button) {
        if (this.pressedButtons.remove(button)) {
            this.baseRobot.releaseMouse(button);
        }
    }
}

