/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.robot.impl;

import java.util.Objects;
import javafx.geometry.HorizontalDirection;
import javafx.geometry.VerticalDirection;
import org.testfx.robot.MouseRobot;
import org.testfx.robot.ScrollRobot;

public class ScrollRobotImpl
implements ScrollRobot {
    private static final int SCROLL_ONE_UP_OR_LEFT = -1;
    private static final int SCROLL_ONE_DOWN_OR_RIGHT = 1;
    private final MouseRobot mouseRobot;

    public ScrollRobotImpl(MouseRobot mouseRobot) {
        Objects.requireNonNull(mouseRobot, "mouseRobot must not be null");
        this.mouseRobot = mouseRobot;
    }

    @Override
    public void scroll(int amount) {
        if (amount >= 0) {
            this.scrollDown(amount);
        } else {
            this.scrollUp(Math.abs(amount));
        }
    }

    @Override
    public void scroll(int positiveAmount, VerticalDirection direction) {
        switch (direction) {
            case UP: {
                this.scrollUp(positiveAmount);
                break;
            }
            case DOWN: {
                this.scrollDown(positiveAmount);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown vertical direction: " + direction);
            }
        }
    }

    @Override
    public void scrollUp(int positiveAmount) {
        for (int scrollTick = 0; scrollTick < positiveAmount; ++scrollTick) {
            this.mouseRobot.scroll(-1);
        }
    }

    @Override
    public void scrollDown(int positiveAmount) {
        for (int scrollTick = 0; scrollTick < positiveAmount; ++scrollTick) {
            this.mouseRobot.scroll(1);
        }
    }

    @Override
    public void scroll(int positiveAmount, HorizontalDirection direction) {
        switch (direction) {
            case RIGHT: {
                this.scrollRight(positiveAmount);
                break;
            }
            case LEFT: {
                this.scrollLeft(positiveAmount);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown horizontal direction: " + direction);
            }
        }
    }

    @Override
    public void scrollRight(int positiveAmount) {
        for (int scrollTick = 0; scrollTick < positiveAmount; ++scrollTick) {
            this.mouseRobot.scroll(1);
        }
    }

    @Override
    public void scrollLeft(int positiveAmount) {
        for (int scrollTick = 0; scrollTick < positiveAmount; ++scrollTick) {
            this.mouseRobot.scroll(-1);
        }
    }
}

