/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.service.query.impl;

import java.util.Optional;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import org.testfx.robot.Motion;
import org.testfx.service.query.PointQuery;
import org.testfx.util.PointQueryUtils;

public abstract class PointQueryBase
implements PointQuery {
    private Point2D position = new Point2D(0.0, 0.0);
    private Point2D offset = new Point2D(0.0, 0.0);
    protected Node node;

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    @Override
    public Point2D getOffset() {
        return this.offset;
    }

    @Override
    public PointQuery atPosition(Point2D position) {
        this.position = position;
        return this;
    }

    @Override
    public PointQuery atPosition(double positionX, double positionY) {
        return this.atPosition(new Point2D(positionX, positionY));
    }

    @Override
    public PointQuery atPosition(Pos position) {
        return this.atPosition(PointQueryUtils.computePositionFactors(position));
    }

    @Override
    public PointQuery atOffset(Point2D offset) {
        this.offset = new Point2D(this.offset.getX() + offset.getX(), this.offset.getY() + offset.getY());
        return this;
    }

    @Override
    public PointQuery atOffset(double offsetX, double offsetY) {
        return this.atOffset(new Point2D(offsetX, offsetY));
    }

    @Override
    public PointQuery onNode(Node node) {
        this.node = node;
        return this;
    }

    @Override
    public Optional<Motion> queryMotion() {
        if (this.node == null) {
            return Optional.empty();
        }
        switch (this.node.getClass().getSimpleName()) {
            case "MenuItemContainer": {
                return Optional.of(Motion.VERTICAL_FIRST);
            }
        }
        return Optional.of(Motion.DEFAULT);
    }

    public String toString() {
        return String.format("PointQueryBase [position = %s, offset = %s node = %s]", this.position, this.offset, this.node);
    }
}

