/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.toolkit.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import javafx.application.Application;
import org.testfx.toolkit.ApplicationLauncher;

public class ApplicationLauncherImpl
implements ApplicationLauncher {
    @Override
    public void launch(Class<? extends Application> appClass, String ... appArgs) {
        this.initMonocleHeadless();
        Application.launch(appClass, (String[])appArgs);
    }

    private void initMonocleHeadless() {
        if (Boolean.getBoolean("testfx.headless")) {
            if (Boolean.getBoolean("testfx.verbose")) {
                System.out.println("testfx: headless mode requested");
            }
            try {
                this.assignMonoclePlatform();
                this.assignHeadlessPlatform();
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException("monocle headless platform not found - did you forget to add a dependency on monocle (https://github.com/TestFX/Monocle)?", exception);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private void assignMonoclePlatform() throws Exception {
        Class<?> platformFactoryClass = Class.forName("com.sun.glass.ui.PlatformFactory");
        Object platformFactoryImpl = Class.forName("com.sun.glass.ui.monocle.MonoclePlatformFactory").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.assignPrivateStaticField(platformFactoryClass, "instance", platformFactoryImpl);
    }

    private void assignHeadlessPlatform() throws Exception {
        Class<?> nativePlatformFactoryClass = Class.forName("com.sun.glass.ui.monocle.NativePlatformFactory");
        try {
            Constructor<?> nativePlatformCtor = Class.forName("com.sun.glass.ui.monocle.HeadlessPlatform").getDeclaredConstructor(new Class[0]);
            nativePlatformCtor.setAccessible(true);
            this.assignPrivateStaticField(nativePlatformFactoryClass, "platform", nativePlatformCtor.newInstance(new Object[0]));
        }
        catch (ClassNotFoundException exception) {
            Constructor<?> nativePlatformCtor = Class.forName("com.sun.glass.ui.monocle.headless.HeadlessPlatform").getDeclaredConstructor(new Class[0]);
            nativePlatformCtor.setAccessible(true);
            this.assignPrivateStaticField(nativePlatformFactoryClass, "platform", nativePlatformCtor.newInstance(new Object[0]));
        }
    }

    private void assignPrivateStaticField(Class<?> clazz, String name, Object value) throws Exception {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        field.set(clazz, value);
        field.setAccessible(false);
    }
}

