/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.view;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.ProcessingContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.fragment.ChainedFragmentSpec;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.spring4.context.SpringWebContext;
import org.thymeleaf.spring4.dialect.SpringStandardDialect;
import org.thymeleaf.spring4.expression.ThymeleafEvaluationContext;
import org.thymeleaf.spring4.view.AbstractThymeleafView;
import org.thymeleaf.standard.expression.FragmentSelectionUtils;
import org.thymeleaf.standard.fragment.StandardFragment;
import org.thymeleaf.standard.fragment.StandardFragmentProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThymeleafView
extends AbstractThymeleafView {
    private static final String pathVariablesSelector;
    private IFragmentSpec fragmentSpec = null;

    protected ThymeleafView() {
    }

    protected ThymeleafView(String templateName) {
        super(templateName);
    }

    public IFragmentSpec getFragmentSpec() {
        return this.fragmentSpec;
    }

    public void setFragmentSpec(IFragmentSpec fragmentSpec) {
        this.fragmentSpec = fragmentSpec;
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.renderFragment(null, model, request, response);
    }

    protected void renderFragment(IFragmentSpec fragmentSpecToRender, Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IFragmentSpec nameFragmentSpec;
        String templateName;
        Map pathVars;
        ServletContext servletContext = this.getServletContext();
        String viewTemplateName = this.getTemplateName();
        SpringTemplateEngine viewTemplateEngine = this.getTemplateEngine();
        if (!viewTemplateEngine.isInitialized()) {
            viewTemplateEngine.initialize();
        }
        if (viewTemplateName == null) {
            throw new IllegalArgumentException("Property 'templateName' is required");
        }
        if (this.getLocale() == null) {
            throw new IllegalArgumentException("Property 'locale' is required");
        }
        if (viewTemplateEngine == null) {
            throw new IllegalArgumentException("Property 'templateEngine' is required");
        }
        HashMap<String, Object> mergedModel = new HashMap<String, Object>(30);
        Map<String, Object> templateStaticVariables = this.getStaticVariables();
        if (templateStaticVariables != null) {
            mergedModel.putAll(templateStaticVariables);
        }
        if (pathVariablesSelector != null && (pathVars = (Map)request.getAttribute(pathVariablesSelector)) != null) {
            mergedModel.putAll(pathVars);
        }
        if (model != null) {
            mergedModel.putAll(model);
        }
        ApplicationContext applicationContext = this.getApplicationContext();
        RequestContext requestContext = new RequestContext(request, response, this.getServletContext(), mergedModel);
        ThymeleafView.addRequestContextAsVariable(mergedModel, "springRequestContext", requestContext);
        ThymeleafView.addRequestContextAsVariable(mergedModel, "springMacroRequestContext", requestContext);
        ConversionService conversionService = (ConversionService)request.getAttribute(ConversionService.class.getName());
        ThymeleafEvaluationContext evaluationContext = new ThymeleafEvaluationContext((BeanFactory)applicationContext, conversionService);
        mergedModel.put("thymeleafEvaluationContext", (Object)evaluationContext);
        SpringWebContext context = new SpringWebContext(request, response, servletContext, this.getLocale(), mergedModel, this.getApplicationContext());
        if (!viewTemplateName.contains("::")) {
            templateName = viewTemplateName;
            nameFragmentSpec = null;
        } else {
            String dialectPrefix;
            ProcessingContext processingContext;
            Configuration configuration = viewTemplateEngine.getConfiguration();
            StandardFragment fragment = StandardFragmentProcessor.computeStandardFragmentSpec((Configuration)configuration, (IProcessingContext)(processingContext = new ProcessingContext((IContext)context)), (String)viewTemplateName, (String)(dialectPrefix = ThymeleafView.getStandardDialectPrefix(configuration)), (String)"fragment");
            if (fragment == null) {
                throw new IllegalArgumentException("Invalid template name specification: '" + viewTemplateName + "'");
            }
            templateName = fragment.getTemplateName();
            nameFragmentSpec = fragment.getFragmentSpec();
            Map nameFragmentParameters = fragment.getParameters();
            if (nameFragmentParameters != null) {
                if (FragmentSelectionUtils.parameterNamesAreSynthetic(nameFragmentParameters.keySet())) {
                    throw new IllegalArgumentException("Parameters in a view specification must be named (non-synthetic): '" + viewTemplateName + "'");
                }
                context.setVariables(nameFragmentParameters);
            }
        }
        String templateContentType = this.getContentType();
        Locale templateLocale = this.getLocale();
        String templateCharacterEncoding = this.getCharacterEncoding();
        Object templateFragmentSpec = fragmentSpecToRender;
        IFragmentSpec viewFragmentSpec = this.getFragmentSpec();
        if (viewFragmentSpec != null) {
            templateFragmentSpec = templateFragmentSpec == null ? viewFragmentSpec : new ChainedFragmentSpec(viewFragmentSpec, templateFragmentSpec);
        }
        if (nameFragmentSpec != null) {
            templateFragmentSpec = templateFragmentSpec == null ? nameFragmentSpec : new ChainedFragmentSpec(nameFragmentSpec, templateFragmentSpec);
        }
        response.setLocale(templateLocale);
        if (templateContentType != null) {
            response.setContentType(templateContentType);
        } else {
            response.setContentType("text/html;charset=ISO-8859-1");
        }
        if (templateCharacterEncoding != null) {
            response.setCharacterEncoding(templateCharacterEncoding);
        }
        viewTemplateEngine.process(templateName, (IContext)context, (IFragmentSpec)templateFragmentSpec, response.getWriter());
    }

    static String getStandardDialectPrefix(Configuration configuration) {
        for (Map.Entry dialectByPrefix : configuration.getDialects().entrySet()) {
            IDialect dialect = (IDialect)dialectByPrefix.getValue();
            if (!SpringStandardDialect.class.isAssignableFrom(dialect.getClass())) continue;
            return (String)dialectByPrefix.getKey();
        }
        throw new ConfigurationException("StandardDialect dialect has not been found. In order to use AjaxThymeleafView, you should configure the " + SpringStandardDialect.class.getName() + " dialect at your Template Engine");
    }

    static {
        String pathVariablesSelectorValue = null;
        try {
            Field pathVariablesField = View.class.getDeclaredField("PATH_VARIABLES");
            pathVariablesSelectorValue = (String)pathVariablesField.get(null);
        }
        catch (NoSuchFieldException ignored) {
            pathVariablesSelectorValue = null;
        }
        catch (IllegalAccessException ignored) {
            pathVariablesSelectorValue = null;
        }
        pathVariablesSelector = pathVariablesSelectorValue;
    }
}

