/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.manager.LazyResolvingFeatureManager;

public class FeatureProxyInvocationHandler
implements InvocationHandler {
    private Feature feature;
    private final Object active;
    private final Object inactive;
    private final FeatureManager featureManager;

    public FeatureProxyInvocationHandler(Feature feature, Object active, Object inactive) {
        this(feature, active, inactive, new LazyResolvingFeatureManager());
    }

    public FeatureProxyInvocationHandler(Feature feature, Object active, Object inactive, FeatureManager featureManager) {
        this.feature = feature;
        this.active = active;
        this.inactive = inactive;
        this.featureManager = featureManager;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object target = this.featureManager.isActive(this.feature) ? this.active : this.inactive;
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
    }

    public Feature getFeature() {
        return this.feature;
    }

    public Object getActive() {
        return this.active;
    }

    public Object getInactive() {
        return this.inactive;
    }
}

