/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.repository;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.togglz.core.Feature;
import org.togglz.core.util.Strings;

public class FeatureState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Feature feature;
    private boolean enabled;
    private String strategyId;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public FeatureState(Feature feature) {
        this(feature, false);
    }

    public FeatureState(Feature feature, boolean enabled) {
        this.feature = feature;
        this.enabled = enabled;
    }

    @Deprecated
    public FeatureState(Feature feature, boolean enabled, List<String> users) {
        this.feature = feature;
        this.enabled = enabled;
        this.strategyId = "username";
        this.addUsers(users);
    }

    public FeatureState copy() {
        FeatureState copy = new FeatureState(this.feature);
        copy.setEnabled(this.enabled);
        copy.setStrategyId(this.strategyId);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            copy.setParameter(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public FeatureState setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public FeatureState enable() {
        return this.setEnabled(true);
    }

    public FeatureState disable() {
        return this.setEnabled(false);
    }

    @Deprecated
    public List<String> getUsers() {
        String value = this.getParameter("users");
        if (Strings.isNotBlank(value)) {
            return Strings.splitAndTrim(value, ",");
        }
        return Collections.emptyList();
    }

    @Deprecated
    public FeatureState addUser(String user) {
        return this.addUsers(Arrays.asList(user));
    }

    @Deprecated
    public FeatureState addUsers(Collection<String> users) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(this.getUsers());
        set.addAll(users);
        String setAsString = Strings.trimToNull(Strings.join(set, ","));
        this.setParameter("users", setAsString);
        return this;
    }

    public String getStrategyId() {
        return this.strategyId;
    }

    public FeatureState setStrategyId(String strategyId) {
        this.strategyId = strategyId;
        return this;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public FeatureState setParameter(String name, String value) {
        if (value != null) {
            this.parameters.put(name, value);
        } else {
            this.parameters.remove(name);
        }
        return this;
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public Map<String, String> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public static FeatureState copyOf(FeatureState featureState) {
        return featureState == null ? null : featureState.copy();
    }
}

