/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.junit.vary;

import java.util.Set;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.togglz.core.Feature;
import org.togglz.core.context.FeatureContext;
import org.togglz.core.manager.FeatureManager;
import org.togglz.testing.TestFeatureManager;
import org.togglz.testing.TestFeatureManagerProvider;

class VariationRunner
extends BlockJUnit4ClassRunner {
    private final Class<? extends Feature> featureClass;
    private final Set<? extends Feature> activeFeatures;

    public VariationRunner(Class<?> testClass, Class<? extends Feature> featureClass, Set<? extends Feature> activeFeatures) throws InitializationError {
        super(testClass);
        this.featureClass = featureClass;
        this.activeFeatures = activeFeatures;
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        final Statement delegate = super.methodInvoker(method, test);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    TestFeatureManager featureManager = new TestFeatureManager(VariationRunner.this.featureClass);
                    for (Feature feature : VariationRunner.this.activeFeatures) {
                        featureManager.enable(feature);
                    }
                    TestFeatureManagerProvider.setFeatureManager((FeatureManager)featureManager);
                    FeatureContext.clearCache();
                    delegate.evaluate();
                }
                finally {
                    TestFeatureManagerProvider.setFeatureManager(null);
                }
            }
        };
    }
}

