/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.repository;

import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;
import org.togglz.spring.repository.FeatureStateChangedEvent;

public class ApplicationEventPublisherRepository
implements StateRepository {
    private final StateRepository delegate;
    private ApplicationEventPublisher applicationEventPublisher;

    public ApplicationEventPublisherRepository(StateRepository delegate, ApplicationEventPublisher applicationEventPublisher) {
        this.delegate = delegate;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public FeatureState getFeatureState(Feature feature) {
        return this.delegate.getFeatureState(feature);
    }

    public void setFeatureState(FeatureState featureState) {
        FeatureState previousFeatureState = this.getFeatureState(featureState.getFeature());
        this.delegate.setFeatureState(featureState);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new FeatureStateChangedEvent(previousFeatureState, featureState));
    }
}

