/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.tomitribe.util.collect.AbstractIterator;
import org.tomitribe.util.collect.FilteredIterator;

public class Files {
    public static final FileFilter ALL = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return true;
        }
    };

    private Files() {
    }

    public static File file(String ... parts) {
        File dir = null;
        for (String part : parts) {
            dir = dir == null ? new File(part) : new File(dir, part);
        }
        return dir;
    }

    public static File file(File dir, String ... parts) {
        for (String part : parts) {
            dir = new File(dir, part);
        }
        return dir;
    }

    public static List<File> collect(File dir) {
        return Files.collect(dir, ALL);
    }

    public static List<File> collect(File dir, String regex) {
        return Files.collect(dir, Pattern.compile(regex));
    }

    public static List<File> collect(File dir, Pattern pattern) {
        return Files.collect(dir, new PatternFileFilter(pattern));
    }

    public static boolean visit(File dir, Visitor visitor) {
        return Files.visit(dir, ALL, visitor);
    }

    public static boolean visit(File dir, String regex, Visitor visitor) {
        return Files.visit(dir, Pattern.compile(regex), visitor);
    }

    public static boolean visit(File dir, Pattern pattern, final Visitor visitor) {
        final PatternFileFilter patternFileFilter = new PatternFileFilter(pattern);
        return Files.visit(dir, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return true;
            }
        }, new Visitor(){

            @Override
            public boolean visit(File file) {
                if (file.isFile() && patternFileFilter.accept(file)) {
                    visitor.visit(file);
                }
                return true;
            }
        });
    }

    public static Iterable<File> iterate(File dir) {
        return Files.iterate(dir, ALL);
    }

    public static Iterable<File> iterate(File dir, String regex) {
        return Files.iterate(dir, Pattern.compile(regex));
    }

    public static Iterable<File> iterate(File dir, Pattern pattern) {
        return Files.iterate(dir, new PatternFileFilter(pattern));
    }

    public static List<File> collect(File dir, FileFilter filter) {
        ArrayList<File> accepted = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (filter.accept(file)) {
                    accepted.add(file);
                }
                accepted.addAll(Files.collect(file, filter));
            }
        }
        return accepted;
    }

    public static Iterable<File> iterate(final File dir, final FileFilter filter) {
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new FilteredIterator<File>(new RecursiveFileIterator(dir), new FilteredIterator.Filter<File>(){

                    @Override
                    public boolean accept(File file) {
                        return filter.accept(file);
                    }
                });
            }
        };
    }

    public static boolean visit(File dir, FileFilter filter, Visitor visitor) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!filter.accept(file)) {
                    return false;
                }
                if (!visitor.visit(file)) {
                    return false;
                }
                if (Files.visit(file, filter, visitor)) continue;
                return false;
            }
        }
        return true;
    }

    public static void exists(File file, String s) {
        if (!file.exists()) {
            throw new IllegalStateException(s + " does not exist: " + file.getAbsolutePath());
        }
    }

    public static void exists(File file) {
        Files.exists(file, "File");
    }

    public static void dir(File file) {
        if (!file.isDirectory()) {
            throw new IllegalStateException("Not a directory: " + file.getAbsolutePath());
        }
    }

    public static void file(File file) {
        if (!file.isFile()) {
            throw new IllegalStateException("Not a file: " + file.getAbsolutePath());
        }
    }

    public static void writable(File file) {
        if (!file.canWrite()) {
            throw new IllegalStateException("Not writable: " + file.getAbsolutePath());
        }
    }

    public static void readable(File file) {
        if (!file.canRead()) {
            throw new IllegalStateException("Not readable: " + file.getAbsolutePath());
        }
    }

    public static File rename(File from, File to) {
        if (!from.renameTo(to)) {
            throw new IllegalStateException("Could not rename " + from.getAbsolutePath() + " to " + to.getAbsolutePath());
        }
        return to;
    }

    public static void remove(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                Files.remove(child);
            }
        }
        if (!file.delete()) {
            throw new IllegalStateException("Could not delete file: " + file.getAbsolutePath());
        }
    }

    public static void mkdir(File file) {
        if (file.exists()) {
            Files.dir(file);
            return;
        }
        if (!file.mkdir()) {
            throw new RuntimeException("Cannot mkdir: " + file.getAbsolutePath());
        }
    }

    public static File tmpdir() {
        try {
            File file = File.createTempFile("temp", "dir");
            if (!file.delete()) {
                throw new IllegalStateException("Cannot make temp dir.  Delete failed");
            }
            Files.mkdir(file);
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void mkparent(File file) {
        Files.mkdirs(file.getParentFile());
    }

    public static File mkparent(File dir, String ... parts) {
        File file = Files.file(dir, parts);
        Files.mkparent(file);
        return file;
    }

    public static File mkdirs(File file) {
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new RuntimeException("Cannot mkdirs: " + file.getAbsolutePath());
            }
        } else {
            Files.dir(file);
        }
        return file;
    }

    public static File resolve(File absolutePath, File path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (path.isAbsolute()) {
            return path;
        }
        if (absolutePath == null) {
            throw new IllegalArgumentException("absolutePath is null");
        }
        Files.absolute(absolutePath);
        return new File(absolutePath, path.getPath());
    }

    public static void absolute(File path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("absolutePath is not absolute: " + path.getPath());
        }
    }

    public static String format(double size) {
        double d;
        double d2;
        double d3;
        double d4;
        if (size < 1024.0) {
            return String.format("%.0f B", size);
        }
        size /= 1024.0;
        if (d4 < 1024.0) {
            return String.format("%.0f KB", size);
        }
        size /= 1024.0;
        if (d3 < 1024.0) {
            return String.format("%.0f MB", size);
        }
        size /= 1024.0;
        if (d2 < 1024.0) {
            return String.format("%.1f GB", size);
        }
        size /= 1024.0;
        if (d < 1024.0) {
            return String.format("%.1f TB", size);
        }
        return "unknown";
    }

    private static class PatternFileFilter
    implements FileFilter {
        private final Pattern pattern;

        public PatternFileFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean accept(File file) {
            return this.pattern.matcher(file.getAbsolutePath()).matches();
        }
    }

    private static class RecursiveFileIterator
    extends AbstractIterator<File> {
        private final LinkedList<FileIterator> stack = new LinkedList();

        public RecursiveFileIterator(File base) {
            this.stack.add(new FileIterator(base));
        }

        @Override
        protected File advance() throws NoSuchElementException {
            FileIterator current = this.stack.element();
            try {
                File file = current.advance();
                if (file == null) {
                    this.stack.pop();
                    return this.advance();
                }
                if (file.isDirectory()) {
                    this.stack.push(new FileIterator(file));
                }
                return file;
            }
            catch (NoSuchElementException e) {
                this.stack.pop();
                return this.advance();
            }
        }
    }

    private static class FileIterator
    extends AbstractIterator<File> {
        private final File[] files;
        private int index;

        private FileIterator(File dir) {
            Files.dir(dir);
            this.files = dir.listFiles();
            this.index = 0;
        }

        @Override
        protected File advance() throws NoSuchElementException {
            if (this.index >= this.files.length) {
                return null;
            }
            return this.files[this.index++];
        }
    }

    public static interface Visitor {
        public boolean visit(File var1);
    }
}

