/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;
import org.tomitribe.util.Join;
import org.tomitribe.util.SizeUnit;
import org.tomitribe.util.editor.Editors;

public class Size {
    private long size;
    private SizeUnit unit;

    public Size() {
    }

    public Size(long size, SizeUnit unit) {
        this.size = size;
        this.unit = unit;
    }

    public Size(String string) {
        this(string, null);
    }

    public Size(String string, SizeUnit defaultUnit) {
        String[] strings = string.split(",| and ");
        Size total = new Size();
        for (String s : strings) {
            String size;
            char c;
            int i;
            Size part = new Size();
            s = s.trim();
            StringBuilder t = new StringBuilder();
            StringBuilder u = new StringBuilder();
            for (i = 0; i < s.length() && (Character.isDigit(c = s.charAt(i)) || i == 0 && c == '-' || i > 0 && c == '.'); ++i) {
                t.append(c);
            }
            if (t.length() == 0) {
                Size.invalidFormat(s);
            }
            while (i < s.length() && Character.isWhitespace(c = s.charAt(i))) {
                ++i;
            }
            while (i < s.length()) {
                c = s.charAt(i);
                if (Character.isLetter(c)) {
                    u.append(c);
                } else {
                    Size.invalidFormat(s);
                }
                ++i;
            }
            part.unit = Size.parseUnit(u.toString());
            if (part.unit == null) {
                part.unit = defaultUnit;
            }
            if ((size = t.toString()).contains(".")) {
                if (part.unit == null) {
                    throw new IllegalArgumentException("unit must be specified with floating point numbers");
                }
                double d = Double.parseDouble(size);
                long bytes = part.unit.toBytes(1L);
                part.size = (long)((double)bytes * d);
                part.unit = SizeUnit.BYTES;
            } else {
                part.size = Integer.parseInt(size);
            }
            total = total.add(part);
        }
        this.size = total.size;
        this.unit = total.unit;
    }

    public long getSize() {
        return this.size;
    }

    public long getSize(SizeUnit unit) {
        return unit.convert(this.size, this.unit);
    }

    public void setSize(long size) {
        this.size = size;
    }

    public SizeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(SizeUnit unit) {
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Size that = (Size)o;
        Normalize n = new Normalize(this, that);
        return n.a == n.b;
    }

    public int hashCode() {
        int result = (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        return result;
    }

    public Size add(Size that) {
        Normalize n = new Normalize(this, that);
        return new Size(n.a + n.b, n.base);
    }

    public Size subtract(Size that) {
        Normalize n = new Normalize(this, that);
        return new Size(n.a - n.b, n.base);
    }

    public static Size parse(String text) {
        return new Size(text);
    }

    private static void invalidFormat(String text) {
        throw new IllegalArgumentException("Illegal size format: '" + text + "'.  Valid examples are '10kb' or '10 " + "kilobytes'.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.size);
        if (this.unit != null) {
            sb.append(" ");
            sb.append((Object)this.unit);
        }
        return sb.toString();
    }

    private static SizeUnit parseUnit(String u) {
        if (u.length() == 0) {
            return null;
        }
        if ("BYTES".equalsIgnoreCase(u)) {
            return SizeUnit.BYTES;
        }
        if ("BYTE".equalsIgnoreCase(u)) {
            return SizeUnit.BYTES;
        }
        if ("B".equalsIgnoreCase(u)) {
            return SizeUnit.BYTES;
        }
        if ("KILOBYTES".equalsIgnoreCase(u)) {
            return SizeUnit.KILOBYTES;
        }
        if ("KILOBYTE".equalsIgnoreCase(u)) {
            return SizeUnit.KILOBYTES;
        }
        if ("KB".equalsIgnoreCase(u)) {
            return SizeUnit.KILOBYTES;
        }
        if ("K".equalsIgnoreCase(u)) {
            return SizeUnit.KILOBYTES;
        }
        if ("MEGABYTES".equalsIgnoreCase(u)) {
            return SizeUnit.MEGABYTES;
        }
        if ("MEGABYTE".equalsIgnoreCase(u)) {
            return SizeUnit.MEGABYTES;
        }
        if ("MB".equalsIgnoreCase(u)) {
            return SizeUnit.MEGABYTES;
        }
        if ("M".equalsIgnoreCase(u)) {
            return SizeUnit.MEGABYTES;
        }
        if ("GIGABYTES".equalsIgnoreCase(u)) {
            return SizeUnit.GIGABYTES;
        }
        if ("GIGABYTE".equalsIgnoreCase(u)) {
            return SizeUnit.GIGABYTES;
        }
        if ("GB".equalsIgnoreCase(u)) {
            return SizeUnit.GIGABYTES;
        }
        if ("G".equalsIgnoreCase(u)) {
            return SizeUnit.GIGABYTES;
        }
        if ("TERABYTES".equalsIgnoreCase(u)) {
            return SizeUnit.TERABYTES;
        }
        if ("TERABYTE".equalsIgnoreCase(u)) {
            return SizeUnit.TERABYTES;
        }
        if ("TB".equalsIgnoreCase(u)) {
            return SizeUnit.TERABYTES;
        }
        if ("T".equalsIgnoreCase(u)) {
            return SizeUnit.TERABYTES;
        }
        throw new IllegalArgumentException("Unknown size unit '" + u + "'.  Supported units " + Join.join(", ", Size.lowercase(SizeUnit.values())));
    }

    private static List<String> lowercase(Enum ... units) {
        ArrayList<String> list = new ArrayList<String>();
        for (Enum unit : units) {
            list.add(unit.name().toLowerCase());
        }
        return list;
    }

    static {
        PropertyEditorManager.registerEditor(Size.class, SizeEditor.class);
        Editors.get(Size.class);
    }

    public static class SizeEditor
    extends PropertyEditorSupport {
        @Override
        public void setAsText(String text) {
            Size d = Size.parse(text);
            this.setValue(d);
        }
    }

    private static class Normalize {
        private long a;
        private long b;
        private SizeUnit base;

        private Normalize(Size a, Size b) {
            this.base = Normalize.lowest(a, b);
            this.a = a.unit == null ? a.size : this.base.convert(a.size, a.unit);
            this.b = b.unit == null ? b.size : this.base.convert(b.size, b.unit);
        }

        private static SizeUnit lowest(Size a, Size b) {
            if (a.unit == null) {
                return b.unit;
            }
            if (b.unit == null) {
                return a.unit;
            }
            if (a.size == 0L) {
                return b.unit;
            }
            if (b.size == 0L) {
                return a.unit;
            }
            return SizeUnit.values()[Math.min(a.unit.ordinal(), b.unit.ordinal())];
        }
    }
}

