/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.mavengem;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.NoSuchFileException;
import org.torquebox.mojo.mavengem.Rubygems;
import org.torquebox.mojo.mavengem.RubygemsFactory;
import org.torquebox.mojo.rubygems.GemArtifactFile;
import org.torquebox.mojo.rubygems.RubygemsFile;

public class MavenGemURLConnection
extends URLConnection {
    public static final String MAVEN_RELEASES = "/maven/releases";
    public static final String PING = "/maven/releases/ping";
    private static final RubygemsFactory NO_RUBYGEMS_FACTORY = null;
    private final Proxy proxy;
    private InputStream in;
    private long timestamp = -1L;
    private int counter = 12;
    final URL baseurl;
    final String path;
    final RubygemsFactory factory;

    public static MavenGemURLConnection create(String uri) throws MalformedURLException {
        return MavenGemURLConnection.create(NO_RUBYGEMS_FACTORY, uri, Proxy.NO_PROXY);
    }

    public static MavenGemURLConnection create(String uri, Proxy proxy) throws MalformedURLException {
        return MavenGemURLConnection.create(NO_RUBYGEMS_FACTORY, uri, proxy);
    }

    public static MavenGemURLConnection create(RubygemsFactory factory, String uri) throws MalformedURLException {
        return MavenGemURLConnection.create(factory, uri, Proxy.NO_PROXY);
    }

    public static MavenGemURLConnection create(RubygemsFactory factory, String uri, Proxy proxy) throws MalformedURLException {
        int index = uri.indexOf(MAVEN_RELEASES);
        String path = uri.substring(index);
        String baseurl = uri.substring(0, index);
        return new MavenGemURLConnection(factory, new URL(baseurl), path, proxy);
    }

    public MavenGemURLConnection(URL baseurl, String path) throws MalformedURLException {
        this(NO_RUBYGEMS_FACTORY, baseurl, path, Proxy.NO_PROXY);
    }

    public MavenGemURLConnection(URL baseurl, String path, Proxy proxy) throws MalformedURLException {
        this(NO_RUBYGEMS_FACTORY, baseurl, path, proxy);
    }

    public MavenGemURLConnection(RubygemsFactory factory, URL baseurl, String path) throws MalformedURLException {
        this(factory, baseurl, path, Proxy.NO_PROXY);
    }

    public MavenGemURLConnection(RubygemsFactory factory, URL baseurl, String path, Proxy proxy) throws MalformedURLException {
        super(baseurl);
        this.proxy = proxy == null ? Proxy.NO_PROXY : proxy;
        this.factory = factory == null ? RubygemsFactory.defaultFactory() : factory;
        this.baseurl = baseurl;
        this.path = path.startsWith(MAVEN_RELEASES) ? path : MAVEN_RELEASES + path;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.connect();
        }
        return this.in;
    }

    @Override
    public synchronized long getLastModified() {
        if (this.timestamp == -1L) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.timestamp;
    }

    @Override
    public synchronized void connect() throws IOException {
        this.connect(this.factory.getOrCreate(this.baseurl));
    }

    private void connect(Rubygems facade) throws IOException {
        RubygemsFile file = facade.get(this.path);
        switch (file.state()) {
            case FORBIDDEN: {
                throw new IOException("forbidden: " + file + " on " + this.baseurl);
            }
            case NOT_EXISTS: {
                if (this.path.equals(PING)) {
                    this.in = new ByteArrayInputStream("pong".getBytes());
                    break;
                }
                throw new FileNotFoundException(file.toString() + " on " + this.baseurl);
            }
            case NO_PAYLOAD: {
                switch (file.type()) {
                    case GEM_ARTIFACT: {
                        this.in = this.openInputStream(this.baseurl + "/gems/" + ((GemArtifactFile)file).gem(null).filename() + ".gem");
                    }
                    case GEM: {
                        this.in = this.openInputStream(this.baseurl + "/" + file.remotePath());
                    }
                }
                throw new FileNotFoundException("view - not implemented. " + file + " on " + this.baseurl);
            }
            case ERROR: {
                if (file.getException() instanceof NoSuchFileException) {
                    throw new FileNotFoundException(file.toString() + " on " + this.baseurl);
                }
                throw new IOException(file.toString() + " on " + this.baseurl, file.getException());
            }
            case TEMP_UNAVAILABLE: {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (--this.counter <= 0) break;
                this.connect(facade);
                break;
            }
            case PAYLOAD: {
                this.in = facade.getInputStream(file);
                this.timestamp = facade.getModified(file);
                break;
            }
            default: {
                throw new RuntimeException("BUG: should never reach here. " + file + " on " + this.baseurl);
            }
        }
    }

    private InputStream openInputStream(String uri) throws IOException {
        if (this.proxy == Proxy.NO_PROXY) {
            return new URL(uri).openStream();
        }
        System.err.println(this.proxy);
        return new URL(uri).openConnection(this.proxy).getInputStream();
    }
}

