/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.jruby.runtime.builtin.IRubyObject;
import org.torquebox.mojo.rubygems.ScriptWrapper;

public class GemRunner
extends ScriptWrapper {
    private final String baseUrl;

    public GemRunner(ScriptingContainer ruby, String baseUrl) {
        super(ruby, GemRunner.newScript(ruby));
        this.baseUrl = baseUrl;
    }

    private static Object newScript(ScriptingContainer scriptingContainer) {
        IRubyObject runnerClass = scriptingContainer.parse(PathType.CLASSPATH, "nexus/gem_runner.rb", new int[0]).run();
        return scriptingContainer.callMethod((Object)runnerClass, "new", IRubyObject.class);
    }

    public String install(String repoId, String ... gems) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("install");
        args.add("-r");
        this.addNoDocu(args);
        this.setSource(args, repoId);
        args.addAll(Arrays.asList(gems));
        return this.callMethod("exec", args.toArray(), String.class);
    }

    private void setSource(List<String> args, String repoId) {
        args.add("--clear-sources");
        args.add("--source");
        args.add(this.baseUrl + repoId + "/");
        args.add("--update-sources");
    }

    public String install(File ... gems) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("install");
        args.add("-l");
        this.addNoDocu(args);
        for (File gem : gems) {
            args.add(gem.getAbsolutePath());
        }
        return this.callMethod("exec", args.toArray(), String.class);
    }

    private void addNoDocu(List<String> args) {
        args.add("--no-rdoc");
        args.add("--no-ri");
    }

    public String push(String repoId, File gem) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("push");
        args.add("--key");
        args.add("test");
        args.add("--host");
        args.add(this.baseUrl + repoId);
        args.add(gem.getAbsolutePath());
        return this.callMethod("exec", args.toArray(), String.class);
    }

    public String clearCache() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("sources");
        args.add("--clear-all");
        return this.callMethod("exec", args.toArray(), String.class);
    }

    public String list() {
        return this.list(null);
    }

    public String list(String repoId) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("list");
        if (repoId == null) {
            args.add("-l");
        } else {
            args.add("-r");
            this.setSource(args, repoId);
        }
        return this.callMethod("exec", args.toArray(), String.class);
    }

    public String nexus(File config, File gem) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("nexus");
        args.add("--nexus-config");
        args.add(config.getAbsolutePath());
        args.add(gem.getAbsolutePath());
        this.callMethod("load_plugins");
        return this.callMethod("exec", args.toArray(), String.class);
    }
}

