/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems.cuba;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.torquebox.mojo.rubygems.RubygemsFile;
import org.torquebox.mojo.rubygems.cuba.Cuba;
import org.torquebox.mojo.rubygems.cuba.State;

public class RootCuba
implements Cuba {
    public static final String _4_8 = ".4.8";
    public static final String GZ = ".gz";
    public static final String API = "api";
    public static final String QUICK = "quick";
    public static final String GEMS = "gems";
    public static final String MAVEN = "maven";
    private static final Pattern SPECS = Pattern.compile("^((prerelease_|latest_)?specs).4.8(.gz)?$");
    private final Cuba api;
    private final Cuba quick;
    private final Cuba gems;
    private final Cuba maven;

    public RootCuba(Cuba api, Cuba quick, Cuba gems, Cuba maven) {
        this.api = api;
        this.quick = quick;
        this.gems = gems;
        this.maven = maven;
    }

    @Override
    public RubygemsFile on(State state) {
        switch (state.name) {
            case "api": {
                return state.nested(this.api);
            }
            case "quick": {
                return state.nested(this.quick);
            }
            case "gems": {
                return state.nested(this.gems);
            }
            case "maven": {
                return state.nested(this.maven);
            }
            case "": {
                return state.context.factory.directory(state.context.original, "api/", "quick/", "gems/", "maven/", "specs.4.8", "latest_specs.4.8", "prerelease_specs.4.8", "specs.4.8.gz", "latest_specs.4.8.gz", "prerelease_specs.4.8.gz");
            }
        }
        Matcher m = SPECS.matcher(state.name);
        if (m.matches()) {
            if (m.group(3) == null) {
                return state.context.factory.specsIndexFile(m.group(1));
            }
            return state.context.factory.specsIndexZippedFile(m.group(1));
        }
        return state.context.factory.notFound(state.context.original);
    }
}

