/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems.cuba;

import java.io.InputStream;
import org.torquebox.mojo.rubygems.FileType;
import org.torquebox.mojo.rubygems.RubygemsFile;
import org.torquebox.mojo.rubygems.RubygemsFileFactory;
import org.torquebox.mojo.rubygems.cuba.Context;
import org.torquebox.mojo.rubygems.cuba.Cuba;
import org.torquebox.mojo.rubygems.cuba.State;
import org.torquebox.mojo.rubygems.layout.Layout;

public class RubygemsFileSystem {
    private final Cuba cuba;
    private final RubygemsFileFactory factory;
    private final Layout getLayout;
    private final Layout postLayout;
    private final Layout deleteLayout;

    protected RubygemsFileSystem(RubygemsFileFactory factory, Layout getLayout, Layout postLayout, Layout deleteLayout, Cuba cuba) {
        this.cuba = cuba;
        this.factory = factory;
        this.getLayout = getLayout;
        this.postLayout = postLayout;
        this.deleteLayout = deleteLayout;
    }

    public RubygemsFile file(String path) {
        return this.visit(this.factory, path, null);
    }

    public RubygemsFile file(String path, String query) {
        return this.visit(this.factory, path, query);
    }

    public RubygemsFile get(String path) {
        return this.visit(this.getLayout, path, null);
    }

    public RubygemsFile get(String path, String query) {
        return this.visit(this.getLayout, path, query);
    }

    private RubygemsFile visit(RubygemsFileFactory factory, String originalPath, String query) {
        if (!(originalPath = originalPath.replace('\\', '/')).startsWith("/")) {
            originalPath = "/" + originalPath;
        }
        String path = originalPath;
        if (query == null) {
            if (originalPath.contains("?")) {
                int index = originalPath.indexOf("?");
                if (index > -1) {
                    query = originalPath.substring(index + 1);
                    path = originalPath.substring(0, index);
                }
            } else {
                query = "";
            }
        }
        return new State(new Context(factory, originalPath, query), path, null).nested(this.cuba);
    }

    public RubygemsFile post(InputStream is, String path) {
        if (this.postLayout != null) {
            RubygemsFile file = this.visit(this.postLayout, path, "");
            if (!file.forbidden() && file.type() != FileType.NOT_FOUND) {
                this.post(is, file);
            }
            return file;
        }
        RubygemsFile file = this.visit(this.factory, path, "");
        file.markAsForbidden();
        return file;
    }

    public void post(InputStream is, RubygemsFile file) {
        this.postLayout.addGem(is, file);
    }

    public RubygemsFile delete(String path) {
        return this.visit(this.deleteLayout, path, "");
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName());
        b.append("<").append(this.cuba.getClass().getSimpleName()).append(">");
        return b.toString();
    }
}

