/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.net.URL;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.DeployableMonitorListener;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.maven2.AbstractDeployerMojo;

public class DeployerDeployMojo
extends AbstractDeployerMojo {
    protected void performDeployerActionOnSingleDeployable(Deployer deployer, Deployable deployable, URL pingURL, Long pingTimeout) {
        this.getLog().debug((CharSequence)("Deploying [" + deployable.getFile() + "]" + (pingURL == null ? " ..." : " using ping URL [" + pingURL + "]" + (pingTimeout == null ? "" : " and ping timeout [" + pingTimeout + "]"))));
        if (pingURL != null) {
            deployer.deploy(deployable, this.createDeployableMonitor(pingURL, pingTimeout, deployable));
        } else {
            deployer.deploy(deployable);
        }
    }

    private DeployableMonitor createDeployableMonitor(URL pingURL, Long pingTimeout, Deployable deployable) {
        URLDeployableMonitor monitor = pingTimeout == null ? new URLDeployableMonitor(pingURL) : new URLDeployableMonitor(pingURL, pingTimeout.longValue());
        DeployerListener listener = new DeployerListener(deployable);
        monitor.registerListener((DeployableMonitorListener)listener);
        return monitor;
    }

    public class DeployerListener
    implements DeployableMonitorListener {
        private Deployable deployable;

        public DeployerListener(Deployable deployable) {
            this.deployable = deployable;
        }

        public void deployed() {
            DeployerDeployMojo.this.getLog().debug((CharSequence)("Watchdog finds [" + this.deployable.getFile() + "] deployed."));
        }

        public void undeployed() {
            DeployerDeployMojo.this.getLog().debug((CharSequence)("Watchdog finds [" + this.deployable.getFile() + "] not deployed yet."));
        }
    }
}

