/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.twdata.maven.cli.PhaseCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseCallBuilder {
    private final MavenProject defaultProject;
    private final Map<String, MavenProject> modules;
    private final Map<String, String> userAliases;

    public PhaseCallBuilder(MavenProject project, Map<String, MavenProject> modules, Map<String, String> userAliases) {
        this.defaultProject = project;
        this.modules = modules;
        this.userAliases = userAliases;
    }

    public List<PhaseCall> parseCommand(String text) {
        ArrayList<PhaseCall> phases = new ArrayList<PhaseCall>();
        PhaseCall currentPhaseCall = null;
        for (String token : this.resolveUserAliases(text)) {
            if (this.modules.containsKey(token)) {
                currentPhaseCall = this.addProject(phases, currentPhaseCall, this.modules.get(token));
                continue;
            }
            if (token.contains("*")) {
                String regexToken = token.replaceAll("\\*", ".*");
                for (String moduleName : this.modules.keySet()) {
                    if (!Pattern.matches(regexToken, moduleName)) continue;
                    currentPhaseCall = this.addProject(phases, currentPhaseCall, this.modules.get(moduleName));
                }
                continue;
            }
            if (token.equals("-o")) {
                this.goOffline(phases, currentPhaseCall);
                continue;
            }
            if (token.equals("-N")) {
                this.disableRecursive(phases, currentPhaseCall);
                continue;
            }
            if (token.equals("-S")) {
                this.addProperty(phases, currentPhaseCall, "-Dmaven.test.skip=true");
                continue;
            }
            if (token.startsWith("-D")) {
                this.addProperty(phases, currentPhaseCall, token);
                continue;
            }
            if (token.startsWith("-P")) {
                this.addProfile(phases, currentPhaseCall, token);
                continue;
            }
            currentPhaseCall = this.addPhase(phases, currentPhaseCall, token);
        }
        return phases;
    }

    private List<String> resolveUserAliases(String text) {
        ArrayList<String> result = new ArrayList<String>();
        for (String token : text.split("\\s")) {
            if (this.userAliases.containsKey(token)) {
                result.addAll(this.resolveUserAliases(this.userAliases.get(token)));
                continue;
            }
            if (StringUtils.isEmpty((String)token)) continue;
            result.add(token);
        }
        return result;
    }

    private PhaseCall addProject(List<PhaseCall> phases, PhaseCall currentPhaseCall, MavenProject project) {
        if (currentPhaseCall == null || !currentPhaseCall.getPhases().isEmpty()) {
            currentPhaseCall = new PhaseCall();
            phases.add(currentPhaseCall);
        }
        currentPhaseCall.addProject(project);
        return currentPhaseCall;
    }

    private PhaseCall addPhase(List<PhaseCall> phases, PhaseCall currentPhaseCall, String phase) {
        if (currentPhaseCall == null) {
            currentPhaseCall = new PhaseCall();
            currentPhaseCall.addProject(this.defaultProject);
            phases.add(currentPhaseCall);
        }
        currentPhaseCall.addPhase(phase);
        return currentPhaseCall;
    }

    private void disableRecursive(List<PhaseCall> phases, PhaseCall currentPhaseCall) {
        if (currentPhaseCall == null) {
            currentPhaseCall = new PhaseCall();
            phases.add(currentPhaseCall);
        }
        currentPhaseCall.doNotRecurse();
    }

    private void goOffline(List<PhaseCall> phases, PhaseCall currentPhaseCall) {
        if (currentPhaseCall == null) {
            currentPhaseCall = new PhaseCall();
            phases.add(currentPhaseCall);
        }
        currentPhaseCall.goOffline();
    }

    private void addProfile(List<PhaseCall> phases, PhaseCall currentPhaseCall, String profile) {
        if (profile.length() < 3) {
            return;
        }
        if (currentPhaseCall == null) {
            currentPhaseCall = new PhaseCall();
            phases.add(currentPhaseCall);
        }
        profile = profile.substring(2);
        currentPhaseCall.addProfile(profile);
    }

    private void addProperty(List<PhaseCall> phases, PhaseCall currentPhaseCall, String property) {
        if (property.length() < 3 || this.hasNoKeyValue(property)) {
            return;
        }
        if (currentPhaseCall == null) {
            currentPhaseCall = new PhaseCall();
            phases.add(currentPhaseCall);
        }
        String key = property = property.substring(2);
        String value = "1";
        if (property.indexOf("=") >= 0) {
            String[] propertyTokens = property.split("=", 2);
            key = propertyTokens[0];
            if (propertyTokens.length > 1) {
                value = propertyTokens[1];
            }
        }
        currentPhaseCall.addProperty(key, value);
    }

    private boolean hasNoKeyValue(String property) {
        return property.charAt(2) == '=' || !property.contains("=") || property.endsWith("=");
    }
}

