/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.TreeMap;
import org.twdata.maven.cli.commands.CommandDescription;
import org.twdata.maven.cli.console.CliConsole;

public class CliConsoleCommandDescription
implements CommandDescription {
    private final CliConsole console;
    private final StringBuilder description = new StringBuilder();
    private final TreeMap<String, String> tokenDescriptions = new TreeMap();

    public CliConsoleCommandDescription(CliConsole console) {
        this.console = console;
    }

    public CommandDescription describeCommandName(String commandName) {
        if (!this.tokenDescriptions.isEmpty()) {
            this.flushTokenDescriptions();
        }
        this.description.append("\n").append(commandName).append(":\n");
        return this;
    }

    private void flushTokenDescriptions() {
        int maxTokenLength = this.determineLongestTokenLength();
        String formattedDescription = this.formatTokenDescriptions(maxTokenLength);
        this.description.append(formattedDescription);
        this.tokenDescriptions.clear();
    }

    private int determineLongestTokenLength() {
        int longestTokenLength = 0;
        for (String token : this.tokenDescriptions.keySet()) {
            longestTokenLength = Math.max(longestTokenLength, token.length());
        }
        return longestTokenLength;
    }

    private String formatTokenDescriptions(int maxTokenLength) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        for (String token : this.tokenDescriptions.keySet()) {
            out.printf(" %-" + maxTokenLength + "s  %s%n", token, this.tokenDescriptions.get(token));
        }
        out.flush();
        out.close();
        return stringWriter.toString();
    }

    public CommandDescription describeCommandToken(String token, String description) {
        if (description == null) {
            this.tokenDescriptions.put(token, "");
        } else {
            this.tokenDescriptions.put(token, description);
        }
        return this;
    }

    public void outputDescription() {
        this.flushTokenDescriptions();
        this.console.writeInfo(this.description.toString());
    }
}

