/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.mojoexecutor;

import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.shaded.mojoexecutor.PlexusConfigurationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MojoExecutor {
    private static final String FAKE_EXECUTION_ID = "virtual-execution";

    public static void executeMojo(Plugin plugin, String goal, Xpp3Dom configuration, ExecutionEnvironment env) throws MojoExecutionException {
        env.executeMojo(plugin, goal, configuration);
    }

    public static void executeMojoImpl(Plugin plugin, String goal, Xpp3Dom configuration, ExecutionEnvironmentM2 env) throws MojoExecutionException {
        Map<String, PluginExecution> executionMap = null;
        try {
            PluginDescriptor pluginDescriptor;
            MojoDescriptor mojoDescriptor;
            MavenSession session = env.getMavenSession();
            List buildPlugins = env.getMavenProject().getBuildPlugins();
            String executionId = null;
            if (goal != null && goal.length() > 0 && goal.indexOf(35) > -1) {
                int pos = goal.indexOf(35);
                executionId = goal.substring(pos + 1);
                goal = goal.substring(0, pos);
                System.out.println("Executing goal " + goal + " with execution ID " + executionId);
            }
            if (buildPlugins != null && executionId == null) {
                for (Object buildPlugin : buildPlugins) {
                    Plugin pomPlugin = (Plugin)buildPlugin;
                    if (!plugin.getGroupId().equals(pomPlugin.getGroupId()) || !plugin.getArtifactId().equals(pomPlugin.getArtifactId())) continue;
                    PluginExecution exec = new PluginExecution();
                    exec.setConfiguration((Object)configuration);
                    executionMap = MojoExecutor.getExecutionsAsMap(pomPlugin);
                    executionMap.put(FAKE_EXECUTION_ID, exec);
                    executionId = FAKE_EXECUTION_ID;
                    break;
                }
            }
            if ((mojoDescriptor = (pluginDescriptor = env.getPluginManager().verifyPlugin(plugin, env.getMavenProject(), session.getSettings(), session.getLocalRepository())).getMojo(goal)) == null) {
                throw new MojoExecutionException("Unknown mojo goal: " + goal);
            }
            MojoExecution exec = MojoExecutor.mojoExecution2(mojoDescriptor, executionId, configuration);
            env.getPluginManager().executeMojo(env.getMavenProject(), exec, env.getMavenSession());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to execute mojo", e);
        }
        finally {
            if (executionMap != null) {
                executionMap.remove(FAKE_EXECUTION_ID);
            }
        }
    }

    public static void executeMojoImpl(Plugin plugin, String goal, Xpp3Dom configuration, ExecutionEnvironmentM3 env) throws MojoExecutionException {
        if (configuration == null) {
            throw new NullPointerException("configuration may not be null");
        }
        Object executionMap = null;
        try {
            String executionId = null;
            if (goal != null && goal.length() > 0 && goal.indexOf(35) > -1) {
                int pos = goal.indexOf(35);
                executionId = goal.substring(pos + 1);
                goal = goal.substring(0, pos);
            }
            MavenSession session = env.getMavenSession();
            PluginDescriptor pluginDescriptor = env.getBuildPluginManager().loadPlugin(plugin, env.getMavenProject().getRemotePluginRepositories(), session.getRepositorySession());
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
            if (mojoDescriptor == null) {
                throw new MojoExecutionException("Could not find goal '" + goal + "' in plugin " + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + plugin.getVersion());
            }
            Xpp3Dom mergedConfig = MojoExecutor.mergeMaven3PomConfig(plugin, configuration, mojoDescriptor, env.getMavenProject(), executionId, goal);
            MojoExecution exec = MojoExecutor.mojoExecution3(mojoDescriptor, executionId, mergedConfig);
            env.getBuildPluginManager().executeMojo(session, exec);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to execute mojo", e);
        }
    }

    private static Xpp3Dom mergeMaven3PomConfig(Plugin plugin, Xpp3Dom configuration, MojoDescriptor mojoDescriptor, MavenProject project, String executionId, String goal) {
        Xpp3Dom finalConfiguration = new Xpp3Dom("configuration");
        Xpp3Dom pomConfig = null;
        List buildPlugins = project.getBuildPlugins();
        if (buildPlugins != null && null == executionId) {
            for (Object buildPlugin : buildPlugins) {
                Plugin pomPlugin = (Plugin)buildPlugin;
                if (!plugin.getGroupId().equals(pomPlugin.getGroupId()) || !plugin.getArtifactId().equals(pomPlugin.getArtifactId())) continue;
                pomConfig = project.getGoalConfiguration(plugin.getGroupId(), plugin.getArtifactId(), executionId, goal);
                break;
            }
        }
        Xpp3Dom mergedConfig = configuration;
        if (null != pomConfig) {
            mergedConfig = Xpp3DomUtils.mergeXpp3Dom(pomConfig, (Xpp3Dom)configuration, (Boolean)true);
            if (null != mergedConfig && null != mojoDescriptor.getParameters()) {
                for (Parameter param : mojoDescriptor.getParameters()) {
                    Xpp3Dom pomParam = mergedConfig.getChild(param.getName());
                    if (null == pomParam) {
                        pomParam = mergedConfig.getChild(param.getAlias());
                    }
                    if (null == pomParam) continue;
                    finalConfiguration.addChild(pomParam);
                }
            }
        } else {
            finalConfiguration = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)configuration, (Xpp3Dom)finalConfiguration, (Boolean)true);
        }
        return finalConfiguration;
    }

    private static Map<String, PluginExecution> getExecutionsAsMap(Plugin pomPlugin) {
        return pomPlugin.getExecutionsAsMap();
    }

    private static MojoExecution mojoExecution2(MojoDescriptor mojoDescriptor, String executionId, Xpp3Dom configuration) {
        if (executionId != null) {
            return new MojoExecution(mojoDescriptor, executionId);
        }
        return new MojoExecution(mojoDescriptor, configuration);
    }

    private static MojoExecution mojoExecution3(MojoDescriptor mojoDescriptor, String executionId, Xpp3Dom configuration) {
        if (executionId != null) {
            return new MojoExecution(mojoDescriptor, executionId);
        }
        configuration = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)configuration, (Xpp3Dom)PlexusConfigurationUtils.toXpp3Dom(mojoDescriptor.getMojoConfiguration()));
        return new MojoExecution(mojoDescriptor, configuration);
    }

    public static ExecutionEnvironment executionEnvironment(MavenProject mavenProject, MavenSession mavenSession, PluginManager pluginManager) {
        return new ExecutionEnvironmentM2(mavenProject, mavenSession, pluginManager);
    }

    public static ExecutionEnvironment executionEnvironment(MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager) {
        return new ExecutionEnvironmentM3(mavenProject, mavenSession, pluginManager);
    }

    public static Xpp3Dom configuration(Element ... elements) {
        Xpp3Dom dom = new Xpp3Dom("configuration");
        for (Element e : elements) {
            dom.addChild(e.toDom());
        }
        return dom;
    }

    public static Plugin plugin(String groupId, String artifactId) {
        return MojoExecutor.plugin(groupId, artifactId, null);
    }

    public static Plugin plugin(String groupId, String artifactId, String version) {
        Plugin plugin = new Plugin();
        plugin.setArtifactId(artifactId);
        plugin.setGroupId(groupId);
        plugin.setVersion(version);
        return plugin;
    }

    public static String groupId(String groupId) {
        return groupId;
    }

    public static String artifactId(String artifactId) {
        return artifactId;
    }

    public static String version(String version) {
        return version;
    }

    public static String goal(String goal) {
        return goal;
    }

    public static String name(String name) {
        return name;
    }

    public static Element element(String name, String value) {
        return new Element(name, value, new Element[0]);
    }

    public static Element element(String name, Element ... elements) {
        return new Element(name, elements);
    }

    public static class ExecutionEnvironmentM3
    extends ExecutionEnvironment {
        private final BuildPluginManager buildPluginManager;

        public ExecutionEnvironmentM3(MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager buildPluginManager) {
            super(mavenProject, mavenSession);
            this.buildPluginManager = buildPluginManager;
        }

        public BuildPluginManager getBuildPluginManager() {
            return this.buildPluginManager;
        }

        public void executeMojo(Plugin plugin, String goal, Xpp3Dom configuration) throws MojoExecutionException {
            MojoExecutor.executeMojoImpl(plugin, goal, configuration, this);
        }
    }

    public static class ExecutionEnvironmentM2
    extends ExecutionEnvironment {
        private final PluginManager pluginManager;

        public ExecutionEnvironmentM2(MavenProject mavenProject, MavenSession mavenSession, PluginManager pluginManager) {
            super(mavenProject, mavenSession);
            this.pluginManager = pluginManager;
        }

        public PluginManager getPluginManager() {
            return this.pluginManager;
        }

        public void executeMojo(Plugin plugin, String goal, Xpp3Dom configuration) throws MojoExecutionException {
            MojoExecutor.executeMojoImpl(plugin, goal, configuration, this);
        }
    }

    public static abstract class ExecutionEnvironment {
        private final MavenProject mavenProject;
        private final MavenSession mavenSession;

        public ExecutionEnvironment(MavenProject mavenProject, MavenSession mavenSession) {
            this.mavenProject = mavenProject;
            this.mavenSession = mavenSession;
        }

        public MavenProject getMavenProject() {
            return this.mavenProject;
        }

        public MavenSession getMavenSession() {
            return this.mavenSession;
        }

        public abstract void executeMojo(Plugin var1, String var2, Xpp3Dom var3) throws MojoExecutionException;
    }

    public static class Element {
        private final Element[] children;
        private final String name;
        private final String text;

        public Element(String name, Element ... children) {
            this(name, (String)null, children);
        }

        public Element(String name, String text, Element ... children) {
            this.name = name;
            this.text = text;
            this.children = children;
        }

        public Xpp3Dom toDom() {
            Xpp3Dom dom = new Xpp3Dom(this.name);
            if (this.text != null) {
                dom.setValue(this.text);
            }
            for (Element e : this.children) {
                dom.addChild(e.toDom());
            }
            return dom;
        }
    }
}

