/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.twdata.maven.cli.AvailablePortFinder;
import org.twdata.maven.cli.CliShell;
import org.twdata.maven.cli.CommandTokenCollector;
import org.twdata.maven.cli.CommandsCompletor;
import org.twdata.maven.cli.MultiOutputStream;
import org.twdata.maven.cli.commands.Command;
import org.twdata.maven.cli.commands.ExitCommand;
import org.twdata.maven.cli.commands.HelpCommand;
import org.twdata.maven.cli.commands.ListProjectsCommand;
import org.twdata.maven.cli.console.JLineCliConsole;

public abstract class AbstractCliMojo
extends AbstractMojo {
    protected MavenProject project;
    protected MavenSession session;
    private List reactorProjects;
    private String prompt = "maven2";
    private String port = null;
    private boolean acceptSocket = true;
    private ServerSocket server = null;
    private CommandsCompletor commandsCompletor;
    private MultiOutputStream mos;
    protected Map<String, MavenProject> modules = new HashMap<String, MavenProject>();
    protected List<Command> cliCommands = new ArrayList<Command>();

    protected abstract void beforeExecute();

    protected abstract Command getSpecializedCliMojoCommand();

    public final void execute() throws MojoExecutionException {
        if (null == this.mos) {
            this.mos = new MultiOutputStream(System.out);
            System.setOut(new PrintStream(this.mos));
        }
        this.beforeExecute();
        this.resolveModulesInProject();
        this.buildCommands();
        this.buildCommandsCompletor();
        Thread consoleShell = this.displayConsoleCliShell();
        this.displaySocketCliShell();
        try {
            consoleShell.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void resolveModulesInProject() {
        for (Object reactorProject : this.reactorProjects) {
            this.modules.put(((MavenProject)reactorProject).getArtifactId(), (MavenProject)reactorProject);
        }
    }

    private void buildCommands() {
        this.cliCommands.add(this.getSpecializedCliMojoCommand());
        this.cliCommands.add(new ExitCommand());
        this.cliCommands.add(new ListProjectsCommand(this.modules.keySet()));
        this.cliCommands.add(new HelpCommand(this.cliCommands));
    }

    private void buildCommandsCompletor() {
        CommandTokenCollector collector = new CommandTokenCollector();
        for (Command command : this.cliCommands) {
            command.collectCommandTokens(collector);
        }
        this.commandsCompletor = new CommandsCompletor(collector.getCollectedTokens());
    }

    private Thread displayConsoleCliShell() {
        Thread shell = new Thread(){

            public void run() {
                try {
                    AbstractCliMojo.this.displayShell(System.in, System.out);
                    AbstractCliMojo.this.acceptSocket = false;
                    if (AbstractCliMojo.this.server != null) {
                        AbstractCliMojo.this.server.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        shell.start();
        return shell;
    }

    private void displaySocketCliShell() {
        String foundPort = "";
        if (this.port != null) {
            try {
                int requestedPort = Integer.parseInt(this.port);
                int plusOne = requestedPort + 1;
                int finalPort = AvailablePortFinder.getPortOrNextAvailable(requestedPort, plusOne);
                foundPort = Integer.toString(finalPort);
                if (requestedPort != finalPort) {
                    this.getLog().warn((CharSequence)("request port " + requestedPort + " was taken. Using new port: " + finalPort));
                }
                this.server = new ServerSocket(finalPort);
                this.openSocket(this.server, finalPort);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Cannot open port " + foundPort + " for cli server: " + e));
                return;
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)e.getMessage());
                return;
            }
        }
    }

    private void displayShell(InputStream in, PrintStream out) {
        JLineCliConsole console = new JLineCliConsole(in, out, this.getLog(), this.commandsCompletor, this.prompt);
        new CliShell(this.cliCommands, console).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSocket(ServerSocket server, int port) {
        this.getLog().info((CharSequence)("Opening port " + port + " for socket cli access"));
        while (this.acceptSocket) {
            Socket connection = null;
            try {
                connection = server.accept();
                PrintStream socketStream = new PrintStream(connection.getOutputStream());
                this.mos.addStream(socketStream);
                this.displayShell(connection.getInputStream(), System.out);
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)"Server quit unexpectedly");
                ex.printStackTrace();
            }
            finally {
                if (connection == null) continue;
                try {
                    connection.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

