/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli.commands;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandTokenizer
implements Iterable<String> {
    private final String text;

    public CommandTokenizer(String command) {
        this.text = command;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            final Matcher m;
            int next;
            {
                this.m = Pattern.compile("\\s+").matcher(CommandTokenizer.this.text);
                this.next = 0;
            }

            @Override
            public boolean hasNext() {
                return this.next < CommandTokenizer.this.text.length();
            }

            @Override
            public String next() {
                String s = this.nextInternal();
                while (s != null && this.count(s, '\"') % 2 == 1 && this.hasNext()) {
                    s = s + this.m.group() + this.nextInternal();
                }
                return s;
            }

            private String nextInternal() {
                if (!this.hasNext()) {
                    return null;
                }
                boolean found = this.m.find(this.next);
                if (found) {
                    String s = CommandTokenizer.this.text.substring(this.next, this.m.start());
                    this.next = this.m.end();
                    return s;
                }
                String s = CommandTokenizer.this.text.substring(this.next);
                this.next = CommandTokenizer.this.text.length();
                return s;
            }

            private int count(String s, char ch) {
                int total = 0;
                int pos = s.indexOf(ch);
                while (pos >= 0) {
                    ++total;
                    pos = s.indexOf(ch, pos + 1);
                }
                return total;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

