/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class CtrlCSignalHandler {
    private volatile boolean supervising;
    private final Thread supervisedThread;

    public CtrlCSignalHandler() {
        this(Thread.currentThread());
    }

    public CtrlCSignalHandler(Thread supervisedThread) {
        this.supervisedThread = supervisedThread;
        this.createAndRegisterSignalHandler();
    }

    private Object createAndRegisterSignalHandler() {
        try {
            Class<?> signalClass = Class.forName("sun.misc.Signal");
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            Object signalHandler = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{signalHandlerClass}, new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (CtrlCSignalHandler.this.supervising && !CtrlCSignalHandler.this.supervisedThread.isInterrupted()) {
                        CtrlCSignalHandler.this.supervisedThread.interrupt();
                    } else {
                        System.exit(1);
                    }
                    return null;
                }
            });
            signalClass.getMethod("handle", signalClass, signalHandlerClass).invoke(null, signalClass.getConstructor(String.class).newInstance("INT"), signalHandler);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void startSupervising() {
        this.supervising = true;
    }

    public void stopSupervising() {
        this.supervising = false;
    }
}

