/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.twdata.maven.cli.PhaseCallRunner;
import org.twdata.maven.cli.console.CliConsole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseCall {
    private final boolean ignoreFailures;
    private final List<String> phases = new ArrayList<String>();
    private final List<String> profiles = new ArrayList<String>();
    private final List<MavenProject> projects = new ArrayList<MavenProject>();
    private final Properties properties = new Properties();
    private boolean offline = false;
    private boolean recursive = true;

    public PhaseCall(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    public void addProject(MavenProject project) {
        this.projects.add(project);
    }

    public List<String> getPhases() {
        return this.phases;
    }

    public void addPhase(String phase) {
        this.phases.add(phase);
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public void addProfile(String profile) {
        this.profiles.add(profile);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void addProperty(String property, String value) {
        this.properties.put(property, value);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void goOffline() {
        this.offline = true;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void doNotRecurse() {
        this.recursive = false;
    }

    public boolean run(PhaseCallRunner runner, CliConsole console) {
        for (MavenProject project : this.projects) {
            boolean success = runner.run(project, this, console);
            if (this.ignoreFailures || success) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MavenProject project : this.projects) {
            sb.append("project: ").append(project.getArtifactId()).append(" ");
        }
        for (String phase : this.phases) {
            sb.append("phase: ").append(phase).append(" ");
        }
        for (String profile : this.profiles) {
            sb.append("profile: ").append(profile).append(" ");
        }
        for (Object propName : this.properties.keySet()) {
            sb.append("property: ").append(propName).append("=").append(this.properties.get(propName)).append(" ");
        }
        return sb.toString();
    }
}

