/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli.commands;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.twdata.maven.cli.CommandTokenCollector;
import org.twdata.maven.cli.commands.CliConsoleCommandDescription;
import org.twdata.maven.cli.commands.Command;
import org.twdata.maven.cli.commands.CommandDescription;
import org.twdata.maven.cli.console.CliConsole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpCommand
implements Command {
    private final Set<String> helpCommands;
    private final List<Command> availableCommands;

    public HelpCommand(List<Command> availableCommands) {
        this.availableCommands = availableCommands;
        HashSet<String> helpCommandTokens = new HashSet<String>();
        helpCommandTokens.add("help");
        helpCommandTokens.add("?");
        this.helpCommands = Collections.unmodifiableSet(helpCommandTokens);
    }

    @Override
    public void describe(CommandDescription description) {
        description.describeCommandName("Help commands").describeCommandToken("help, ?", null);
    }

    @Override
    public void collectCommandTokens(CommandTokenCollector collector) {
        collector.addCommandTokens(this.helpCommands);
    }

    @Override
    public boolean matchesRequest(String request) {
        return this.helpCommands.contains(request);
    }

    @Override
    public boolean run(String request, CliConsole console) {
        CliConsoleCommandDescription description = new CliConsoleCommandDescription(console);
        for (Command command : this.availableCommands) {
            command.describe(description);
        }
        description.outputDescription();
        return true;
    }
}

