/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli.commands;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.twdata.maven.cli.CommandTokenCollector;
import org.twdata.maven.cli.commands.Command;
import org.twdata.maven.cli.commands.CommandDescription;
import org.twdata.maven.cli.console.CliConsole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListProjectsCommand
implements Command {
    private final Set<String> listCommands;
    private final Set<String> projectNames;

    public ListProjectsCommand(Set<String> projectNames) {
        this.projectNames = projectNames;
        HashSet<String> commands = new HashSet<String>();
        commands.add("list");
        commands.add("ls");
        this.listCommands = Collections.unmodifiableSet(commands);
    }

    @Override
    public void describe(CommandDescription description) {
        description.describeCommandName("List module commands").describeCommandToken("list, ls", null);
    }

    @Override
    public void collectCommandTokens(CommandTokenCollector collector) {
        collector.addCommandTokens(this.listCommands);
    }

    @Override
    public boolean matchesRequest(String request) {
        return this.listCommands.contains(request);
    }

    @Override
    public boolean run(String request, CliConsole console) {
        console.writeInfo("Listing available projects: ");
        for (String projectName : this.projectNames) {
            console.writeInfo("* " + projectName);
        }
        return true;
    }
}

