/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.mojoexecutor;

import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MojoExecutor {
    private static final String FAKE_EXECUTION_ID = "virtual-execution";

    public static void executeMojo(Plugin plugin, String goal, Xpp3Dom configuration, ExecutionEnvironment env) throws MojoExecutionException {
        Map executionMap = null;
        try {
            MavenSession session = env.getMavenSession();
            List buildPlugins = env.getMavenProject().getBuildPlugins();
            String executionId = null;
            if (goal != null && goal.length() > 0 && goal.indexOf(35) > -1) {
                int pos = goal.indexOf(35);
                executionId = goal.substring(pos + 1);
                goal = goal.substring(0, pos);
                System.out.println("Executing goal " + goal + " with execution ID " + executionId);
            }
            if (buildPlugins != null && executionId == null) {
                for (Plugin pomPlugin : buildPlugins) {
                    if (!plugin.getGroupId().equals(pomPlugin.getGroupId()) || !plugin.getArtifactId().equals(pomPlugin.getArtifactId())) continue;
                    PluginExecution exec = new PluginExecution();
                    exec.setConfiguration((Object)configuration);
                    executionMap = pomPlugin.getExecutionsAsMap();
                    executionMap.put(FAKE_EXECUTION_ID, exec);
                    executionId = FAKE_EXECUTION_ID;
                    break;
                }
            }
            PluginDescriptor pluginDescriptor = env.getPluginManager().verifyPlugin(plugin, env.getMavenProject(), session.getSettings(), session.getLocalRepository());
            MojoExecution exec = null;
            exec = executionId != null ? new MojoExecution(pluginDescriptor.getMojo(goal), executionId) : new MojoExecution(pluginDescriptor.getMojo(goal), configuration);
            env.getPluginManager().executeMojo(env.getMavenProject(), exec, env.getMavenSession());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to execute mojo", e);
        }
        finally {
            if (executionMap != null) {
                executionMap.remove(FAKE_EXECUTION_ID);
            }
        }
    }

    public static ExecutionEnvironment executionEnvironment(MavenProject mavenProject, MavenSession mavenSession, PluginManager pluginManager) {
        return new ExecutionEnvironment(mavenProject, mavenSession, pluginManager);
    }

    public static Xpp3Dom configuration(Element ... elements) {
        Xpp3Dom dom = new Xpp3Dom("configuration");
        for (Element e : elements) {
            dom.addChild(e.toDom());
        }
        return dom;
    }

    public static Plugin plugin(String groupId, String artifactId) {
        return MojoExecutor.plugin(groupId, artifactId, null);
    }

    public static Plugin plugin(String groupId, String artifactId, String version) {
        Plugin plugin = new Plugin();
        plugin.setArtifactId(artifactId);
        plugin.setGroupId(groupId);
        plugin.setVersion(version);
        return plugin;
    }

    public static String groupId(String groupId) {
        return groupId;
    }

    public static String artifactId(String artifactId) {
        return artifactId;
    }

    public static String version(String version) {
        return version;
    }

    public static String goal(String goal) {
        return goal;
    }

    public static String name(String name) {
        return name;
    }

    public static Element element(String name, String value) {
        return new Element(name, value, new Element[0]);
    }

    public static Element element(String name, Element ... elements) {
        return new Element(name, elements);
    }

    public static class ExecutionEnvironment {
        private final MavenProject mavenProject;
        private final MavenSession mavenSession;
        private final PluginManager pluginManager;

        public ExecutionEnvironment(MavenProject mavenProject, MavenSession mavenSession, PluginManager pluginManager) {
            this.mavenProject = mavenProject;
            this.mavenSession = mavenSession;
            this.pluginManager = pluginManager;
        }

        public MavenProject getMavenProject() {
            return this.mavenProject;
        }

        public MavenSession getMavenSession() {
            return this.mavenSession;
        }

        public PluginManager getPluginManager() {
            return this.pluginManager;
        }
    }

    public static class Element {
        private final Element[] children;
        private final String name;
        private final String text;

        public Element(String name, Element ... children) {
            this(name, (String)null, children);
        }

        public Element(String name, String text, Element ... children) {
            this.name = name;
            this.text = text;
            this.children = children;
        }

        public Xpp3Dom toDom() {
            Xpp3Dom dom = new Xpp3Dom(this.name);
            if (this.text != null) {
                dom.setValue(this.text);
            }
            for (Element e : this.children) {
                dom.addChild(e.toDom());
            }
            return dom;
        }
    }
}

