/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak;

import javax.enterprise.context.Dependent;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.keycloak.BaseClientFactory;
import org.uberfire.ext.security.management.keycloak.client.Keycloak;
import org.uberfire.ext.security.management.keycloak.client.auth.credentials.AuthSettings;
import org.uberfire.ext.security.management.keycloak.client.auth.credentials.AuthTokenManager;

@Dependent
public class CredentialsClientFactory
extends BaseClientFactory {
    private static final String DEFAULT_REALM = "example";
    private static final String DEFAULT_USER = "examples-admin-client";
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_CLIENT_ID = "examples-admin-client";
    private static final String DEFAULT_CLIENT_SECRET = "";
    private static final String DEFAULT_USE_RESOURCE_ROLE_MAPPING = "false";
    private static final String DEFAULT_RESOURCE = "kie";

    public void init(ConfigProperties config) {
        ConfigProperties.ConfigProperty authServer = config.get("org.uberfire.ext.security.management.keycloak.authServer", "http://localhost:8080/auth");
        ConfigProperties.ConfigProperty realm = config.get("org.uberfire.ext.security.management.keycloak.realm", DEFAULT_REALM);
        ConfigProperties.ConfigProperty user = config.get("org.uberfire.ext.security.management.keycloak.user", "examples-admin-client");
        ConfigProperties.ConfigProperty password = config.get("org.uberfire.ext.security.management.keycloak.password", "");
        ConfigProperties.ConfigProperty clientId = config.get("org.uberfire.ext.security.management.keycloak.clientId", "examples-admin-client");
        ConfigProperties.ConfigProperty clientSecret = config.get("org.uberfire.ext.security.management.keycloak.clientSecret", "");
        ConfigProperties.ConfigProperty useRoleResourceMappings = config.get("org.uberfire.ext.security.management.keycloak.use-resource-role-mappings", DEFAULT_USE_RESOURCE_ROLE_MAPPING);
        ConfigProperties.ConfigProperty resource = config.get("org.uberfire.ext.security.management.keycloak.resource", DEFAULT_RESOURCE);
        if (clientId.getValue().isEmpty() && clientSecret.getValue().isEmpty()) {
            throw new IllegalArgumentException("Keycloack ID and client secret are unset.");
        }
        this.client = Keycloak.getInstance(authServer.getValue(), realm.getValue(), resource.getValue(), useRoleResourceMappings.getBooleanValue(), new AuthTokenManager(new AuthSettings(authServer.getValue(), realm.getValue(), resource.getValue(), user.getValue(), password.getValue(), clientId.getValue(), clientSecret.getValue())));
    }
}

