/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak.client.auth.credentials;

import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.keycloak.common.util.Time;
import org.keycloak.util.BasicAuthHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.security.management.keycloak.client.auth.TokenManager;
import org.uberfire.ext.security.management.keycloak.client.auth.TokenService;
import org.uberfire.ext.security.management.keycloak.client.auth.credentials.AccessTokenResponse;
import org.uberfire.ext.security.management.keycloak.client.auth.credentials.AuthSettings;

public class AuthTokenManager
implements TokenManager {
    private static final Logger LOG = LoggerFactory.getLogger(AuthTokenManager.class);
    private static final long DEFAULT_MIN_VALIDITY = 30L;
    private final AuthSettings config;
    long expirationTime;
    long minTokenValidity = 30L;
    AccessTokenResponse accessTokenResponse;
    private final ClientErrorInterceptor clientErrorInterceptor = new ClientErrorInterceptor(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(ClientResponse<?> response) throws RuntimeException {
            AuthTokenManager.this.accessTokenResponse = null;
            String error = null;
            IOException exception = null;
            try {
                BaseClientResponse r = (BaseClientResponse)response;
                InputStream stream = r.getStreamFactory().getInputStream();
                stream.reset();
                if (Response.Status.FORBIDDEN.equals((Object)response.getResponseStatus())) {
                    error = "Error handling the Keycloak token, status is FORBIDDEN";
                } else if (Response.Status.UNAUTHORIZED.equals((Object)response.getResponseStatus())) {
                    error = "Error handling the Keycloak token, status is UNAUTHORIZED";
                } else if (Response.Status.BAD_REQUEST.equals((Object)response.getResponseStatus())) {
                    error = "Error handling the Keycloak token, status is BAD_REQUEST. Response data: " + this.getResponseData(r);
                } else if (Response.Status.NOT_FOUND.equals((Object)response.getResponseStatus())) {
                    error = "Error handling the Keycloak token, status is NOT_FOUND.";
                } else if (!Response.Status.OK.equals((Object)response.getResponseStatus())) {
                    error = "Error handling the Keycloak token. Response status is " + response.getResponseStatus() + ". Response data: " + this.getResponseData(r);
                }
            }
            catch (IOException e) {
                error = "Error handling the Keycloak token.";
                exception = e;
            }
            finally {
                response.releaseConnection();
            }
            if (null != error) {
                LOG.error(error);
                if (null != exception) {
                    throw new RuntimeException(error, exception);
                }
                throw new RuntimeException(error);
            }
        }

        private String getResponseData(BaseClientResponse response) {
            try {
                return (String)response.getEntity(String.class);
            }
            catch (Exception e) {
                LOG.error("Error trying to obtain response data as String.", (Throwable)e);
                return null;
            }
        }
    };

    public AuthTokenManager(AuthSettings config) {
        this.config = config;
    }

    @Override
    public void grantToken() {
        CaseInsensitiveMap mvm = new CaseInsensitiveMap();
        mvm.putSingle((Object)"grant_type", (Object)"password");
        mvm.putSingle((Object)"username", (Object)this.config.getUsername());
        mvm.putSingle((Object)"password", (Object)this.config.getPassword());
        this.consumeGrantTokenService((MultivaluedMap<String, String>)mvm);
    }

    private void refreshToken() {
        CaseInsensitiveMap mvm = new CaseInsensitiveMap();
        mvm.putSingle((Object)"grant_type", (Object)"refresh_token");
        mvm.putSingle((Object)"refresh_token", (Object)this.accessTokenResponse.getRefreshToken());
        this.consumeGrantTokenService((MultivaluedMap<String, String>)mvm);
    }

    protected void consumeGrantTokenService(MultivaluedMap<String, String> mvm) {
        boolean isPublic = this.config.isPublicClient();
        String authorization = "";
        if (isPublic) {
            mvm.putSingle((Object)"client_id", (Object)this.config.getClientId());
        } else {
            authorization = BasicAuthHelper.createHeader((String)this.config.getClientId(), (String)this.config.getClientSecret());
        }
        TokenService client = this.createTokenService();
        AccessTokenResponse response = client.grantToken(this.config.getRealm(), authorization, mvm);
        int requestTime = Time.currentTime();
        this.expirationTime = (long)requestTime + response.getExpiresIn();
        this.accessTokenResponse = response;
    }

    @Override
    public String getAccessTokenString() {
        if (null == this.accessTokenResponse) {
            this.grantToken();
        } else if (this.tokenExpired()) {
            this.refreshToken();
        }
        return this.accessTokenResponse != null ? this.accessTokenResponse.getToken() : null;
    }

    @Override
    public String getRealm() {
        return this.config.getRealm();
    }

    @Override
    public String getResource() {
        return this.config.getResource();
    }

    TokenService createTokenService() {
        ResteasyProviderFactory pf = ResteasyProviderFactory.getInstance();
        pf.addClientErrorInterceptor(this.clientErrorInterceptor);
        return (TokenService)ProxyFactory.create(TokenService.class, (String)this.config.getServerUrl());
    }

    private boolean tokenExpired() {
        return this.accessTokenResponse != null && (long)Time.currentTime() + this.minTokenValidity >= this.expirationTime;
    }
}

