/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.editors.metafile;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.workbench.type.DotResourceType;
import org.uberfire.ext.widgets.common.client.ace.AceEditorMode;
import org.uberfire.ext.widgets.core.client.editors.texteditor.TextEditorPresenter;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.lifecycle.IsDirty;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnSave;
import org.uberfire.lifecycle.OnStartup;

@Dependent
@WorkbenchEditor(identifier="MetaFileTextEditor", supportedTypes={DotResourceType.class}, priority=2147483547)
public class MetaFileEditorPresenter {
    @Inject
    public TextEditorPresenter.View view;
    @Inject
    private Caller<VFSService> vfsServices;
    private Path path;

    @OnStartup
    public void onStartup(ObservablePath path) {
        this.path = path;
        ((VFSService)this.vfsServices.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String response) {
                if (response == null) {
                    MetaFileEditorPresenter.this.view.setContent(CoreConstants.INSTANCE.EmptyEntry(), AceEditorMode.TEXT);
                } else {
                    MetaFileEditorPresenter.this.view.setContent(response, AceEditorMode.TEXT);
                }
            }
        })).readAllString((Path)path);
    }

    @OnSave
    public void onSave() {
        ((VFSService)this.vfsServices.call((RemoteCallback)new RemoteCallback<Path>(){

            public void callback(Path response) {
                MetaFileEditorPresenter.this.view.setDirty(false);
            }
        })).write(this.path, this.view.getContent());
    }

    @IsDirty
    public boolean isDirty() {
        return this.view.isDirty();
    }

    @OnClose
    public void onClose() {
        this.path = null;
    }

    @OnOpen
    public void onOpen() {
        this.view.setFocus();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return CoreConstants.INSTANCE.MetaFileEditor() + " [" + this.path.getFileName() + "]";
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.view;
    }
}

