/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.editors.defaulteditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.Map;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.base.form.AbstractForm;
import org.uberfire.ext.widgets.common.client.common.FileUpload;
import org.uberfire.ext.widgets.common.client.common.FileUploadFormEncoder;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.mvp.Command;

public abstract class DefaultEditorFileUploadBase
extends Composite {
    private static DefaultEditorFileUploadBaseBinder uiBinder = (DefaultEditorFileUploadBaseBinder)GWT.create(DefaultEditorFileUploadBaseBinder.class);
    @UiField
    Form form;
    @UiField(provided=true)
    FileUpload fileUpload;
    private Command successCallback;
    private Command errorCallback;
    private FileUploadFormEncoder formEncoder = new FileUploadFormEncoder();

    public DefaultEditorFileUploadBase() {
        this(true);
    }

    public DefaultEditorFileUploadBase(boolean showUpload) {
        this.fileUpload = this.createFileUpload(showUpload);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.initForm();
    }

    static boolean isUploadSuccessful(AbstractForm.SubmitCompleteEvent submitEvent) {
        return "OK".equalsIgnoreCase(submitEvent.getResults());
    }

    void initForm() {
        this.form.setEncoding("multipart/form-data");
        this.form.setMethod("post");
        this.formEncoder.addUtf8Charset(this.form);
        this.form.addSubmitCompleteHandler(event -> {
            if (DefaultEditorFileUploadBase.isUploadSuccessful(event)) {
                Window.alert((String)CoreConstants.INSTANCE.UploadSuccess());
                this.executeCallback(this.successCallback);
            } else {
                Window.alert((String)CoreConstants.INSTANCE.UploadFail());
                this.executeCallback(this.errorCallback);
            }
        });
    }

    private FileUpload createFileUpload(boolean showUpload) {
        return new FileUpload(new Command(){

            public void execute() {
                DefaultEditorFileUploadBase.this.form.setAction(GWT.getModuleBaseURL() + "defaulteditor/upload" + DefaultEditorFileUploadBase.this.createParametersForURL());
                if (DefaultEditorFileUploadBase.this.isValid()) {
                    DefaultEditorFileUploadBase.this.form.submit();
                }
            }
        }, showUpload);
    }

    boolean isValid() {
        String fileName = this.fileUpload.getFilename();
        if (this.isNullOrEmpty(fileName)) {
            Window.alert((String)CoreConstants.INSTANCE.SelectFileToUpload());
            this.executeCallback(this.errorCallback);
            return false;
        }
        return true;
    }

    private boolean isNullOrEmpty(String fileName) {
        return fileName == null || "".equals(fileName);
    }

    private String createParametersForURL() {
        String parameters = "?";
        Map<String, String> map = this.getParameters();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String parameter = iterator.next();
            parameters = parameters + parameter + "=" + map.get(parameter);
            if (!iterator.hasNext()) continue;
            parameters = parameters + "&";
        }
        return parameters;
    }

    protected abstract Map<String, String> getParameters();

    public void upload(Command successCallback, Command errorCallback) {
        this.successCallback = successCallback;
        this.errorCallback = errorCallback;
        this.fileUpload.upload();
    }

    public String getFormFileName() {
        return this.fileUpload.getFilename();
    }

    private void executeCallback(Command callback) {
        if (callback == null) {
            return;
        }
        callback.execute();
    }

    static interface DefaultEditorFileUploadBaseBinder
    extends UiBinder<Widget, DefaultEditorFileUploadBase> {
    }
}

