/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.editors.texteditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ResizeLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import org.uberfire.ext.widgets.common.client.ace.AceEditor;
import org.uberfire.ext.widgets.common.client.ace.AceEditorMode;
import org.uberfire.ext.widgets.common.client.ace.AceEditorTheme;
import org.uberfire.ext.widgets.core.client.editors.texteditor.TextEditorPresenter;

public class TextEditorView
extends Composite
implements RequiresResize,
TextEditorPresenter.View {
    private static TextEditorViewBinder uiBinder = (TextEditorViewBinder)GWT.create(TextEditorViewBinder.class);
    @UiField
    public AceEditor editor;
    private boolean isDirty = false;

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.editor.startEditor();
        this.editor.setTheme(AceEditorTheme.CHROME);
    }

    @Override
    public void setContent(String content, AceEditorMode mode) {
        this.editor.setMode(mode);
        this.editor.setText(content);
        this.editor.redisplay();
    }

    @Override
    public String getContent() {
        return this.editor.getText();
    }

    @Override
    public void setFocus() {
        this.editor.setFocus();
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        this.editor.setReadOnly(isReadOnly);
    }

    public void onResize() {
        int height = this.getParent().getOffsetHeight();
        int width = this.getParent().getOffsetWidth();
        this.setPixelSize(width, height);
        this.editor.onResize();
    }

    static interface TextEditorViewBinder
    extends UiBinder<ResizeLayoutPanel, TextEditorView> {
    }
}

