/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.editors.texteditor;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.type.DotResourceType;
import org.uberfire.ext.widgets.core.client.editors.texteditor.TextEditorPresenter;
import org.uberfire.ext.widgets.core.client.editors.texteditor.TextResourceType;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.lifecycle.IsDirty;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnSave;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchEditor(identifier="TextEditor", supportedTypes={TextResourceType.class, DotResourceType.class})
public class TextEditorWorkbenchEditor
extends TextEditorPresenter {
    @Inject
    private Caller<VFSService> vfsServices;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;

    @OnStartup
    public void onStartup(final Path path, final PlaceRequest placeRequest) {
        ((VFSService)this.vfsServices.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String response) {
                if (response == null) {
                    TextEditorWorkbenchEditor.this.view.setContent(CoreConstants.INSTANCE.EmptyEntry(), TextEditorWorkbenchEditor.this.getAceEditorMode());
                } else {
                    TextEditorWorkbenchEditor.this.view.setContent(response, TextEditorWorkbenchEditor.this.getAceEditorMode());
                }
                TextEditorWorkbenchEditor.this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(placeRequest, CoreConstants.INSTANCE.TextEditor() + " [" + path.getFileName() + "]"));
            }
        })).readAllString(path);
    }

    @OnSave
    public void onSave() {
        ((VFSService)this.vfsServices.call((RemoteCallback)new RemoteCallback<Path>(){

            public void callback(Path response) {
                TextEditorWorkbenchEditor.this.view.setDirty(false);
            }
        })).write(this.path, this.view.getContent());
    }

    @Override
    @IsDirty
    public boolean isDirty() {
        return super.isDirty();
    }

    @OnClose
    public void onClose() {
        this.path = null;
    }

    @Override
    @OnOpen
    public void onOpen() {
        super.onOpen();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return CoreConstants.INSTANCE.TextEditor();
    }

    @Override
    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }
}

