/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.util;

import java.util.List;
import java.util.Properties;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.core.dbsupport.DbSupportFactory;
import org.unitils.core.dbsupport.SQLHandler;
import org.unitils.dbmaintainer.util.DatabaseAccessing;

public abstract class BaseDatabaseAccessor
implements DatabaseAccessing {
    protected Properties configuration;
    protected SQLHandler sqlHandler;
    protected DbSupport defaultDbSupport;
    protected List<DbSupport> dbSupports;
    protected String dialect;

    @Override
    public void init(Properties configuration, SQLHandler sqlHandler, String dialect, List<String> schemaNames) {
        this.configuration = configuration;
        this.sqlHandler = sqlHandler;
        this.dbSupports = DbSupportFactory.getDbSupports((Properties)configuration, (SQLHandler)sqlHandler, (String)dialect, schemaNames);
        this.defaultDbSupport = DbSupportFactory.getDefaultDbSupport((Properties)configuration, (SQLHandler)sqlHandler, (String)dialect, (String)schemaNames.get(0));
        this.dialect = dialect;
        this.doInit(configuration);
    }

    protected void doInit(Properties configuration) {
    }

    public DbSupport getDbSupport(String schemaName) {
        return DbSupportFactory.getDbSupport((Properties)this.configuration, (SQLHandler)this.sqlHandler, (String)schemaName, (String)this.dialect);
    }
}

