/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.script.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.dbmaintainer.locator.ClassPathScriptLocator;
import org.unitils.dbmaintainer.locator.resourcepickingstrategie.ResourcePickingStrategie;
import org.unitils.dbmaintainer.locator.resourcepickingstrategie.impl.UniqueMostRecentPickingStrategie;
import org.unitils.dbmaintainer.script.Script;
import org.unitils.dbmaintainer.script.impl.DefaultScriptSource;
import org.unitils.util.PropertyUtils;

public class ResourceScriptSource
extends DefaultScriptSource {
    private static final Log LOGGER = LogFactory.getLog(ResourceScriptSource.class);

    @Override
    protected List<Script> loadAllScripts(String dialect, String databaseName, boolean defaultDatabase) {
        List scriptLocations = PropertyUtils.getStringList((String)"dbMaintainer.script.locations", (Properties)this.configuration);
        if (dialect != null) {
            List dbSpecificLocations = PropertyUtils.getStringList((String)("dbMaintainer.script.locations." + dialect), (Properties)this.configuration);
            scriptLocations.addAll(dbSpecificLocations);
        }
        List scriptIgnoredLocations = PropertyUtils.getStringList((String)"dbMaintainer.script.locations.ignore", (Properties)this.configuration);
        ArrayList<String> ignoredSubLocations = new ArrayList<String>();
        for (String locationIgnorded : scriptIgnoredLocations) {
            for (String scriptLocation : scriptLocations) {
                if (!locationIgnorded.startsWith(scriptLocation)) continue;
                String sublocation = locationIgnorded.replace(scriptLocation, "");
                if (sublocation.startsWith("/")) {
                    sublocation = sublocation.substring(1);
                }
                ignoredSubLocations.add(sublocation);
            }
        }
        LOGGER.debug((Object)("Ignorded sublocations for script search: " + ArrayUtils.toString((Object)ignoredSubLocations.toArray())));
        ArrayList<Script> scripts = new ArrayList<Script>();
        for (String scriptLocation : scriptLocations) {
            this.getScriptsAt(scripts, scriptLocation, "", databaseName, defaultDatabase);
        }
        ArrayList<Script> scriptsToRemove = new ArrayList<Script>();
        for (Script script : scripts) {
            for (String ignoredSublocation : ignoredSubLocations) {
                if (!script.getFileName().startsWith(ignoredSublocation)) continue;
                LOGGER.debug((Object)("Removing script '" + script.getFileName() + "' because in ignored sub-location " + ignoredSublocation));
                scriptsToRemove.add(script);
            }
        }
        scripts.removeAll(scriptsToRemove);
        LOGGER.debug((Object)("Scripts found: " + scripts.size()));
        return scripts;
    }

    @Override
    protected void getScriptsAt(List<Script> scripts, String scriptRoot, String relativeLocation, String databaseName, boolean defaultDatabase) {
        if (!scriptRoot.endsWith("/")) {
            scriptRoot = scriptRoot + "/";
        }
        String location = scriptRoot;
        LOGGER.debug((Object)("Script location: " + location));
        ClassPathScriptLocator classPathScriptLocator = new ClassPathScriptLocator();
        classPathScriptLocator.loadScripts(scripts, scriptRoot, this.getResourcePickingStrategie(), this.getScriptExtensions(), databaseName, defaultDatabase, this.configuration);
        ArrayList<Script> tempScripts = new ArrayList<Script>();
        for (Script script : scripts) {
            if (!this.checkIfScriptContainsCorrectDatabaseName(script.getFileName(), databaseName, defaultDatabase) || !this.containsOneOfQualifiers(script.getFileName())) continue;
            tempScripts.add(script);
        }
        scripts = tempScripts;
    }

    protected ResourcePickingStrategie getResourcePickingStrategie() {
        return new UniqueMostRecentPickingStrategie();
    }
}

