/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.DirectoryScanner;
import org.vafer.jdeb.Console;
import org.vafer.jdeb.debian.BinaryPackageControlFile;
import org.vafer.jdeb.mapping.PermMapper;
import org.vafer.jdeb.shaded.commons.compress.archivers.tar.TarArchiveEntry;
import org.vafer.jdeb.shaded.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.vafer.jdeb.shaded.commons.io.IOUtils;
import org.vafer.jdeb.shaded.commons.io.output.NullOutputStream;
import org.vafer.jdeb.utils.FilteredFile;
import org.vafer.jdeb.utils.InformationInputStream;
import org.vafer.jdeb.utils.Utils;
import org.vafer.jdeb.utils.VariableResolver;

class ControlBuilder {
    private static final Set<String> MAINTAINER_SCRIPTS = new HashSet<String>(Arrays.asList("preinst", "postinst", "prerm", "postrm", "config"));
    private static final Set<String> CONFIGURATION_FILENAMES = new HashSet<String>(Arrays.asList("conffiles", "templates", "triggers"));
    private Console console;
    private VariableResolver resolver;
    private final String openReplaceToken;
    private final String closeReplaceToken;

    ControlBuilder(Console console, VariableResolver resolver, String openReplaceToken, String closeReplaceToken) {
        this.console = console;
        this.resolver = resolver;
        this.openReplaceToken = openReplaceToken;
        this.closeReplaceToken = closeReplaceToken;
    }

    void buildControl(BinaryPackageControlFile packageControlFile, File[] controlFiles, List<String> conffiles, StringBuilder checksums, File output) throws IOException, ParseException {
        File dir = output.getParentFile();
        if (!(dir == null || dir.exists() && dir.isDirectory())) {
            throw new IOException("Cannot write control file at '" + output.getAbsolutePath() + "'");
        }
        TarArchiveOutputStream outputStream = new TarArchiveOutputStream(new GZIPOutputStream(new FileOutputStream(output)));
        outputStream.setLongFileMode(2);
        boolean foundConffiles = false;
        for (File file : controlFiles) {
            if (file.isDirectory()) {
                if (this.isDefaultExcludes(file)) continue;
                this.console.warn("Found directory '" + file + "' in the control directory. Maybe you are pointing to wrong dir?");
                continue;
            }
            if ("conffiles".equals(file.getName())) {
                foundConffiles = true;
            }
            if (CONFIGURATION_FILENAMES.contains(file.getName()) || MAINTAINER_SCRIPTS.contains(file.getName())) {
                FilteredFile configurationFile = new FilteredFile(new FileInputStream(file), this.resolver);
                configurationFile.setOpenToken(this.openReplaceToken);
                configurationFile.setCloseToken(this.closeReplaceToken);
                ControlBuilder.addControlEntry(file.getName(), configurationFile.toString(), outputStream);
                continue;
            }
            if ("control".equals(file.getName())) continue;
            InformationInputStream infoStream = new InformationInputStream(new FileInputStream(file));
            Utils.copy(infoStream, NullOutputStream.NULL_OUTPUT_STREAM);
            infoStream.close();
            InputStream in = new FileInputStream(file);
            if (infoStream.isShell() && !infoStream.hasUnixLineEndings()) {
                byte[] buf = Utils.toUnixLineEndings(in);
                in = new ByteArrayInputStream(buf);
            }
            ControlBuilder.addControlEntry(file.getName(), IOUtils.toString(in), outputStream);
            ((InputStream)in).close();
        }
        if (foundConffiles) {
            this.console.info("Found file 'conffiles' in the control directory. Skipping conffiles generation.");
        } else if (conffiles != null && conffiles.size() > 0) {
            ControlBuilder.addControlEntry("conffiles", this.createPackageConffilesFile(conffiles), outputStream);
        } else {
            this.console.info("Skipping 'conffiles' generation. No entries defined in maven/pom or ant/build.xml.");
        }
        if (packageControlFile == null) {
            throw new FileNotFoundException("No 'control' file found in " + controlFiles.toString());
        }
        ControlBuilder.addControlEntry("control", packageControlFile.toString(), outputStream);
        ControlBuilder.addControlEntry("md5sums", checksums.toString(), outputStream);
        outputStream.close();
    }

    private String createPackageConffilesFile(List<String> conffiles) {
        StringBuilder content = new StringBuilder();
        if (conffiles != null && !conffiles.isEmpty()) {
            for (String nextFileName : conffiles) {
                content.append(nextFileName).append("\n");
            }
        }
        return content.toString();
    }

    public BinaryPackageControlFile createPackageControlFile(File file, BigInteger pDataSize) throws IOException, ParseException {
        FilteredFile controlFile = new FilteredFile(new FileInputStream(file), this.resolver);
        BinaryPackageControlFile packageControlFile = new BinaryPackageControlFile(controlFile.toString());
        if (packageControlFile.get("Distribution") == null) {
            packageControlFile.set("Distribution", "unknown");
        }
        if (packageControlFile.get("Urgency") == null) {
            packageControlFile.set("Urgency", "low");
        }
        packageControlFile.set("Installed-Size", pDataSize.divide(BigInteger.valueOf(1024L)).toString());
        String debVersion = System.getenv("DEBVERSION");
        if (debVersion != null) {
            packageControlFile.set("Version", debVersion);
            this.console.debug("Using version'" + debVersion + "' from the environment variables.");
        }
        String debFullName = System.getenv("DEBFULLNAME");
        String debEmail = System.getenv("DEBEMAIL");
        if (debFullName != null && debEmail != null) {
            String maintainer = debFullName + " <" + debEmail + ">";
            packageControlFile.set("Maintainer", maintainer);
            this.console.debug("Using maintainer '" + maintainer + "' from the environment variables.");
        }
        return packageControlFile;
    }

    private static void addControlEntry(String pName, String pContent, TarArchiveOutputStream pOutput) throws IOException {
        byte[] data = pContent.getBytes("UTF-8");
        TarArchiveEntry entry = new TarArchiveEntry("./" + pName, true);
        entry.setSize(data.length);
        entry.setNames("root", "root");
        if (MAINTAINER_SCRIPTS.contains(pName)) {
            entry.setMode(PermMapper.toMode("755"));
        } else {
            entry.setMode(PermMapper.toMode("644"));
        }
        pOutput.putArchiveEntry(entry);
        pOutput.write(data);
        pOutput.closeArchiveEntry();
    }

    private boolean isDefaultExcludes(File directory) {
        for (String pattern : DirectoryScanner.getDefaultExcludes()) {
            if (!DirectoryScanner.match((String)pattern, (String)directory.getAbsolutePath().replace("\\", "/"))) continue;
            return true;
        }
        return false;
    }
}

