/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.debian;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class ControlField {
    private String name;
    private boolean mandatory;
    private Type type = Type.SIMPLE;
    private boolean firstLineEmpty;

    public ControlField(String name) {
        this(name, false);
    }

    public ControlField(String name, boolean mandatory) {
        this(name, mandatory, Type.SIMPLE);
    }

    public ControlField(String name, boolean mandatory, Type type) {
        this(name, mandatory, type, false);
    }

    public ControlField(String name, boolean mandatory, Type type, boolean firstLineEmpty) {
        this.name = name;
        this.mandatory = mandatory;
        this.type = type;
        this.firstLineEmpty = firstLineEmpty;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isFirstLineEmpty() {
        return this.firstLineEmpty;
    }

    public String format(String value) {
        StringBuilder s = new StringBuilder();
        if (value != null && value.trim().length() > 0) {
            boolean continuationLine = false;
            s.append(this.getName()).append(":");
            if (this.isFirstLineEmpty()) {
                s.append("\n");
                continuationLine = true;
            }
            try {
                String line;
                BufferedReader reader = new BufferedReader(new StringReader(value));
                while ((line = reader.readLine()) != null) {
                    if (continuationLine && line.trim().length() == 0) {
                        s.append(" .\n");
                    } else {
                        s.append(" ").append(line).append("\n");
                    }
                    continuationLine = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return s.toString();
    }

    public static enum Type {
        SIMPLE,
        FOLDED,
        MULTILINE;

    }
}

