/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.vafer.jdeb.shaded.bc.bcpg.CompressedDataPacket;
import org.vafer.jdeb.shaded.bc.bcpg.ExperimentalPacket;
import org.vafer.jdeb.shaded.bc.bcpg.InputStreamPacket;
import org.vafer.jdeb.shaded.bc.bcpg.LiteralDataPacket;
import org.vafer.jdeb.shaded.bc.bcpg.MarkerPacket;
import org.vafer.jdeb.shaded.bc.bcpg.ModDetectionCodePacket;
import org.vafer.jdeb.shaded.bc.bcpg.OnePassSignaturePacket;
import org.vafer.jdeb.shaded.bc.bcpg.Packet;
import org.vafer.jdeb.shaded.bc.bcpg.PacketTags;
import org.vafer.jdeb.shaded.bc.bcpg.PublicKeyEncSessionPacket;
import org.vafer.jdeb.shaded.bc.bcpg.PublicKeyPacket;
import org.vafer.jdeb.shaded.bc.bcpg.PublicSubkeyPacket;
import org.vafer.jdeb.shaded.bc.bcpg.SecretKeyPacket;
import org.vafer.jdeb.shaded.bc.bcpg.SecretSubkeyPacket;
import org.vafer.jdeb.shaded.bc.bcpg.SignaturePacket;
import org.vafer.jdeb.shaded.bc.bcpg.SymmetricEncDataPacket;
import org.vafer.jdeb.shaded.bc.bcpg.SymmetricEncIntegrityPacket;
import org.vafer.jdeb.shaded.bc.bcpg.SymmetricKeyEncSessionPacket;
import org.vafer.jdeb.shaded.bc.bcpg.TrustPacket;
import org.vafer.jdeb.shaded.bc.bcpg.UserAttributePacket;
import org.vafer.jdeb.shaded.bc.bcpg.UserIDPacket;
import org.vafer.jdeb.shaded.bc.util.io.Streams;

public class BCPGInputStream
extends InputStream
implements PacketTags {
    InputStream in;
    boolean next = false;
    int nextB;

    public BCPGInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public int read() throws IOException {
        if (this.next) {
            this.next = false;
            return this.nextB;
        }
        return this.in.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (!this.next) {
            return this.in.read(byArray, n, n2);
        }
        if (this.nextB < 0) {
            return -1;
        }
        byArray[n] = (byte)this.nextB;
        this.next = false;
        return 1;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (Streams.readFully(this, byArray, n, n2) < n2) {
            throw new EOFException();
        }
    }

    public byte[] readAll() throws IOException {
        return Streams.readAll(this);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public int nextPacketTag() throws IOException {
        if (!this.next) {
            try {
                this.nextB = this.in.read();
            }
            catch (EOFException eOFException) {
                this.nextB = -1;
            }
            this.next = true;
        }
        if (this.nextB < 0) {
            return this.nextB;
        }
        int n = this.nextB & 0x3F;
        if ((this.nextB & 0x40) == 0) {
            n >>= 2;
        }
        return n;
    }

    public Packet readPacket() throws IOException {
        int n;
        int n2 = this.read();
        if (n2 < 0) {
            return null;
        }
        if ((n2 & 0x80) == 0) {
            throw new IOException("invalid header encountered");
        }
        boolean bl = (n2 & 0x40) != 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        if (bl) {
            n3 = n2 & 0x3F;
            n = this.read();
            if (n < 192) {
                n4 = n;
            } else if (n <= 223) {
                int n5 = this.in.read();
                n4 = (n - 192 << 8) + n5 + 192;
            } else if (n == 255) {
                n4 = this.in.read() << 24 | this.in.read() << 16 | this.in.read() << 8 | this.in.read();
            } else {
                bl2 = true;
                n4 = 1 << (n & 0x1F);
            }
        } else {
            n = n2 & 3;
            n3 = (n2 & 0x3F) >> 2;
            switch (n) {
                case 0: {
                    n4 = this.read();
                    break;
                }
                case 1: {
                    n4 = this.read() << 8 | this.read();
                    break;
                }
                case 2: {
                    n4 = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
                    break;
                }
                case 3: {
                    bl2 = true;
                    break;
                }
                default: {
                    throw new IOException("unknown length type encountered");
                }
            }
        }
        BCPGInputStream bCPGInputStream = n4 == 0 && bl2 ? this : new BCPGInputStream(new PartialInputStream(this, bl2, n4));
        switch (n3) {
            case 0: {
                return new InputStreamPacket(bCPGInputStream);
            }
            case 1: {
                return new PublicKeyEncSessionPacket(bCPGInputStream);
            }
            case 2: {
                return new SignaturePacket(bCPGInputStream);
            }
            case 3: {
                return new SymmetricKeyEncSessionPacket(bCPGInputStream);
            }
            case 4: {
                return new OnePassSignaturePacket(bCPGInputStream);
            }
            case 5: {
                return new SecretKeyPacket(bCPGInputStream);
            }
            case 6: {
                return new PublicKeyPacket(bCPGInputStream);
            }
            case 7: {
                return new SecretSubkeyPacket(bCPGInputStream);
            }
            case 8: {
                return new CompressedDataPacket(bCPGInputStream);
            }
            case 9: {
                return new SymmetricEncDataPacket(bCPGInputStream);
            }
            case 10: {
                return new MarkerPacket(bCPGInputStream);
            }
            case 11: {
                return new LiteralDataPacket(bCPGInputStream);
            }
            case 12: {
                return new TrustPacket(bCPGInputStream);
            }
            case 13: {
                return new UserIDPacket(bCPGInputStream);
            }
            case 17: {
                return new UserAttributePacket(bCPGInputStream);
            }
            case 14: {
                return new PublicSubkeyPacket(bCPGInputStream);
            }
            case 18: {
                return new SymmetricEncIntegrityPacket(bCPGInputStream);
            }
            case 19: {
                return new ModDetectionCodePacket(bCPGInputStream);
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return new ExperimentalPacket(n3, bCPGInputStream);
            }
        }
        throw new IOException("unknown packet type encountered: " + n3);
    }

    public void close() throws IOException {
        this.in.close();
    }

    private static class PartialInputStream
    extends InputStream {
        private BCPGInputStream in;
        private boolean partial;
        private int dataLength;

        PartialInputStream(BCPGInputStream bCPGInputStream, boolean bl, int n) {
            this.in = bCPGInputStream;
            this.partial = bl;
            this.dataLength = n;
        }

        public int available() throws IOException {
            int n = this.in.available();
            if (n <= this.dataLength || this.dataLength < 0) {
                return n;
            }
            if (this.partial && this.dataLength == 0) {
                return 1;
            }
            return this.dataLength;
        }

        private int loadDataLength() throws IOException {
            int n = this.in.read();
            if (n < 0) {
                return -1;
            }
            this.partial = false;
            if (n < 192) {
                this.dataLength = n;
            } else if (n <= 223) {
                this.dataLength = (n - 192 << 8) + this.in.read() + 192;
            } else if (n == 255) {
                this.dataLength = this.in.read() << 24 | this.in.read() << 16 | this.in.read() << 8 | this.in.read();
            } else {
                this.partial = true;
                this.dataLength = 1 << (n & 0x1F);
            }
            return this.dataLength;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            do {
                if (this.dataLength == 0) continue;
                int n3 = this.dataLength > n2 || this.dataLength < 0 ? n2 : this.dataLength;
                if ((n3 = this.in.read(byArray, n, n3)) < 0) {
                    throw new EOFException("premature end of stream in PartialInputStream");
                }
                this.dataLength -= n3;
                return n3;
            } while (this.partial && this.loadDataLength() >= 0);
            return -1;
        }

        public int read() throws IOException {
            do {
                if (this.dataLength == 0) continue;
                int n = this.in.read();
                if (n < 0) {
                    throw new EOFException("premature end of stream in PartialInputStream");
                }
                --this.dataLength;
                return n;
            } while (this.partial && this.loadDataLength() >= 0);
            return -1;
        }
    }
}

