/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosLang;
import org.verapdf.gf.model.impl.cos.GFCosUnicodeName;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pd.structure.StructureType;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class GFPDStructElem
extends GFPDObject
implements org.verapdf.model.pdlayer.PDStructElem {
    public static final String STRUCTURE_ELEMENT_TYPE = "PDStructElem";
    public static final String CHILDREN = "K";
    public static final String STRUCTURE_TYPE = "S";
    public static final String LANG = "Lang";

    public GFPDStructElem(PDStructElem structElemDictionary) {
        super((PDObject)structElemDictionary, STRUCTURE_ELEMENT_TYPE);
    }

    public String getType() {
        ASAtom type = ((PDStructElem)this.simplePDObject).getType();
        return type == null ? null : type.getValue();
    }

    public String getstandardType() {
        if (StaticContainers.getFlavour().getPart() == PDFAFlavour.Specification.ISO_19005_4) {
            StructureType defaultStructureType = ((PDStructElem)this.simplePDObject).getDefaultStructureType();
            if (defaultStructureType != null) {
                return defaultStructureType.getType().getValue();
            }
        } else {
            StructureType type = ((PDStructElem)this.simplePDObject).getStructureType();
            if (type != null) {
                return StaticContainers.getRoleMapHelper().getStandardType(type.getType());
            }
        }
        return null;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "K": {
                return this.getChildren();
            }
            case "S": {
                return this.getStructureType();
            }
            case "Lang": {
                return this.getLang();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDStructElem> getChildren() {
        List elements = ((PDStructElem)this.simplePDObject).getChildren();
        if (!elements.isEmpty()) {
            ArrayList<GFPDStructElem> res = new ArrayList<GFPDStructElem>(elements.size());
            for (PDStructElem element : elements) {
                res.add(new GFPDStructElem(element));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<CosUnicodeName> getStructureType() {
        COSName type = ((PDStructElem)this.simplePDObject).getCOSStructureType();
        if (type != null) {
            ArrayList<GFCosUnicodeName> list = new ArrayList<GFCosUnicodeName>(1);
            list.add(new GFCosUnicodeName(type));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<CosLang> getLang() {
        COSString baseLang = ((PDStructElem)this.simplePDObject).getLang();
        if (baseLang != null) {
            ArrayList<GFCosLang> list = new ArrayList<GFCosLang>(1);
            list.add(new GFCosLang(baseLang));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

