/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi.datatypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.datatypes.Array;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.AbiTypes;

public abstract class StaticArray<T extends Type>
extends Array<T> {
    public static final int MAX_SIZE_OF_STATIC_ARRAY = 32;

    @Deprecated
    @SafeVarargs
    public StaticArray(T ... values) {
        this(values.length, (Type[])values);
    }

    @Deprecated
    @SafeVarargs
    public StaticArray(int expectedSize, T ... values) {
        this(expectedSize, Arrays.asList(values));
    }

    @Deprecated
    public StaticArray(List<T> values) {
        this(values.size(), values);
    }

    @Deprecated
    public StaticArray(int expectedSize, List<T> values) {
        super(AbiTypes.getType(((Type)values.get(0)).getTypeAsString()), values);
        this.checkValid(expectedSize);
    }

    @SafeVarargs
    public StaticArray(Class<T> type, T ... values) {
        this(type, Arrays.asList(values));
    }

    @SafeVarargs
    public StaticArray(Class<T> type, int expectedSize, T ... values) {
        this(type, expectedSize, Arrays.asList(values));
    }

    public StaticArray(Class<T> type, List<T> values) {
        this(type, values == null ? 0 : values.size(), values);
    }

    public StaticArray(Class<T> type, int expectedSize, List<T> values) {
        super(type, values);
        this.checkValid(expectedSize);
    }

    @Override
    public List<T> getValue() {
        return Collections.unmodifiableList(this.value);
    }

    @Override
    public String getTypeAsString() {
        return AbiTypes.getTypeAString(this.getComponentType()) + "[" + this.value.size() + "]";
    }

    private void checkValid(int expectedSize) {
        if (this.value.size() > 32) {
            throw new UnsupportedOperationException("Static arrays with a length greater than 32 are not supported.");
        }
        if (this.value.size() != expectedSize) {
            throw new UnsupportedOperationException("Expected array of type [" + this.getClass().getSimpleName() + "] to have [" + expectedSize + "] elements.");
        }
    }
}

