/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Array;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Bytes;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.DynamicStruct;
import org.web3j.abi.datatypes.Fixed;
import org.web3j.abi.datatypes.FixedPointType;
import org.web3j.abi.datatypes.NumericType;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.StaticStruct;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Ufixed;
import org.web3j.abi.datatypes.Uint;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.primitive.PrimitiveType;
import org.web3j.utils.Numeric;

public class TypeEncoder {
    private TypeEncoder() {
    }

    static boolean isDynamic(Type parameter) {
        return parameter instanceof DynamicBytes || parameter instanceof Utf8String || parameter instanceof DynamicArray || parameter instanceof StaticArray && DynamicStruct.class.isAssignableFrom(((StaticArray)parameter).getComponentType());
    }

    public static String encode(Type parameter) {
        if (parameter instanceof NumericType) {
            return TypeEncoder.encodeNumeric((NumericType)parameter);
        }
        if (parameter instanceof Address) {
            return TypeEncoder.encodeAddress((Address)parameter);
        }
        if (parameter instanceof Bool) {
            return TypeEncoder.encodeBool((Bool)parameter);
        }
        if (parameter instanceof Bytes) {
            return TypeEncoder.encodeBytes((Bytes)parameter);
        }
        if (parameter instanceof DynamicBytes) {
            return TypeEncoder.encodeDynamicBytes((DynamicBytes)parameter);
        }
        if (parameter instanceof Utf8String) {
            return TypeEncoder.encodeString((Utf8String)parameter);
        }
        if (parameter instanceof StaticArray) {
            if (DynamicStruct.class.isAssignableFrom(((StaticArray)parameter).getComponentType())) {
                return TypeEncoder.encodeStaticArrayWithDynamicStruct((StaticArray)parameter);
            }
            return TypeEncoder.encodeArrayValues((StaticArray)parameter);
        }
        if (parameter instanceof DynamicStruct) {
            return TypeEncoder.encodeDynamicStruct((DynamicStruct)parameter);
        }
        if (parameter instanceof DynamicArray) {
            return TypeEncoder.encodeDynamicArray((DynamicArray)parameter);
        }
        if (parameter instanceof PrimitiveType) {
            return TypeEncoder.encode(((PrimitiveType)parameter).toSolidityType());
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + String.valueOf(parameter.getClass()));
    }

    public static String encodePacked(Type parameter) {
        if (parameter instanceof Utf8String) {
            return Numeric.toHexStringNoPrefix((byte[])((Utf8String)parameter).getValue().getBytes(StandardCharsets.UTF_8));
        }
        if (parameter instanceof DynamicBytes) {
            return Numeric.toHexStringNoPrefix((byte[])((DynamicBytes)parameter).getValue());
        }
        if (parameter instanceof DynamicArray) {
            return TypeEncoder.arrayEncodePacked((DynamicArray)parameter);
        }
        if (parameter instanceof StaticArray) {
            return TypeEncoder.arrayEncodePacked((StaticArray)parameter);
        }
        if (parameter instanceof PrimitiveType) {
            return TypeEncoder.encodePacked(((PrimitiveType)parameter).toSolidityType());
        }
        return TypeEncoder.removePadding(TypeEncoder.encode(parameter), parameter);
    }

    static String removePadding(String encodedValue, Type parameter) {
        if (parameter instanceof NumericType) {
            if (parameter instanceof Ufixed || parameter instanceof Fixed) {
                return encodedValue;
            }
            return encodedValue.substring(64 - ((NumericType)parameter).getBitSize() / 4, 64);
        }
        if (parameter instanceof Address) {
            return encodedValue.substring(64 - ((Address)parameter).toUint().getBitSize() / 4, 64);
        }
        if (parameter instanceof Bool) {
            return encodedValue.substring(62, 64);
        }
        if (parameter instanceof Bytes) {
            return encodedValue.substring(0, ((BytesType)parameter).getValue().length * 2);
        }
        if (parameter instanceof Utf8String) {
            int length = ((Utf8String)parameter).getValue().getBytes(StandardCharsets.UTF_8).length;
            return encodedValue.substring(64, 64 + length * 2);
        }
        if (parameter instanceof DynamicBytes) {
            return encodedValue.substring(64, 64 + ((DynamicBytes)parameter).getValue().length * 2);
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + String.valueOf(parameter.getClass()));
    }

    private static <T extends Type> String encodeStaticArrayWithDynamicStruct(Array<T> value) {
        String valuesOffsets = TypeEncoder.encodeDynamicsTypesArraysOffsets(value);
        String encodedValues = TypeEncoder.encodeArrayValues(value);
        StringBuilder result = new StringBuilder();
        result.append(valuesOffsets);
        result.append(encodedValues);
        return result.toString();
    }

    static String encodeAddress(Address address) {
        return TypeEncoder.encodeNumeric(address.toUint());
    }

    static String encodeNumeric(NumericType numericType) {
        byte[] rawValue = TypeEncoder.toByteArray(numericType);
        byte paddingValue = TypeEncoder.getPaddingValue(numericType);
        byte[] paddedRawValue = new byte[32];
        if (paddingValue != 0) {
            for (int i = 0; i < paddedRawValue.length; ++i) {
                paddedRawValue[i] = paddingValue;
            }
        }
        System.arraycopy(rawValue, 0, paddedRawValue, 32 - rawValue.length, rawValue.length);
        return Numeric.toHexStringNoPrefix((byte[])paddedRawValue);
    }

    private static byte getPaddingValue(NumericType numericType) {
        if (numericType.getValue().signum() == -1) {
            return -1;
        }
        return 0;
    }

    private static byte[] toByteArray(NumericType numericType) {
        BigInteger value = numericType.getValue();
        if ((numericType instanceof Ufixed || numericType instanceof Uint) && value.bitLength() == 256) {
            byte[] byteArray = new byte[32];
            System.arraycopy(value.toByteArray(), 1, byteArray, 0, 32);
            return byteArray;
        }
        return value.toByteArray();
    }

    static String encodeBool(Bool value) {
        byte[] rawValue = new byte[32];
        if (value.getValue().booleanValue()) {
            rawValue[rawValue.length - 1] = 1;
        }
        return Numeric.toHexStringNoPrefix((byte[])rawValue);
    }

    static String encodeBytes(BytesType bytesType) {
        byte[] dest;
        byte[] value = bytesType.getValue();
        int length = value.length;
        int mod = length % 32;
        if (mod != 0) {
            int padding = 32 - mod;
            dest = new byte[length + padding];
            System.arraycopy(value, 0, dest, 0, length);
        } else {
            dest = value;
        }
        return Numeric.toHexStringNoPrefix((byte[])dest);
    }

    static String encodeDynamicBytes(DynamicBytes dynamicBytes) {
        int size = dynamicBytes.getValue().length;
        String encodedLength = TypeEncoder.encode(new Uint(BigInteger.valueOf(size)));
        String encodedValue = TypeEncoder.encodeBytes(dynamicBytes);
        StringBuilder result = new StringBuilder();
        result.append(encodedLength);
        result.append(encodedValue);
        return result.toString();
    }

    static String encodeString(Utf8String string) {
        byte[] utfEncoded = string.getValue().getBytes(StandardCharsets.UTF_8);
        return TypeEncoder.encodeDynamicBytes(new DynamicBytes(utfEncoded));
    }

    static <T extends Type> String encodeArrayValues(Array<T> value) {
        StringBuilder result = new StringBuilder();
        Iterator iterator = value.getValue().iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            result.append(TypeEncoder.encode(type));
        }
        return result.toString();
    }

    static String encodeDynamicStruct(DynamicStruct value) {
        String encodedValues = TypeEncoder.encodeDynamicStructValues(value);
        StringBuilder result = new StringBuilder();
        result.append(encodedValues);
        return result.toString();
    }

    private static String encodeDynamicStructValues(DynamicStruct value) {
        int staticSize = 0;
        for (int i = 0; i < value.getValue().size(); ++i) {
            Type type = (Type)value.getValue().get(i);
            if (TypeEncoder.isDynamic(type)) {
                staticSize += 32;
                continue;
            }
            staticSize += type.bytes32PaddedLength();
        }
        int dynamicOffset = staticSize;
        ArrayList<String> offsetsAndStaticValues = new ArrayList<String>();
        ArrayList<String> dynamicValues = new ArrayList<String>();
        for (int i = 0; i < value.getValue().size(); ++i) {
            Type type = (Type)value.getValue().get(i);
            if (TypeEncoder.isDynamic(type)) {
                offsetsAndStaticValues.add(Numeric.toHexStringNoPrefix((byte[])Numeric.toBytesPadded((BigInteger)new BigInteger(Long.toString(dynamicOffset)), (int)32)));
                String encodedValue = TypeEncoder.encode(type);
                dynamicValues.add(encodedValue);
                dynamicOffset += encodedValue.length() >> 1;
                continue;
            }
            offsetsAndStaticValues.add(TypeEncoder.encode((Type)value.getValue().get(i)));
        }
        ArrayList<String> data = new ArrayList<String>();
        data.addAll(offsetsAndStaticValues);
        data.addAll(dynamicValues);
        return String.join((CharSequence)"", data);
    }

    static <T extends Type> String encodeDynamicArray(DynamicArray<T> value) {
        int size = value.getValue().size();
        String encodedLength = TypeEncoder.encode(new Uint(BigInteger.valueOf(size)));
        String valuesOffsets = TypeEncoder.encodeArrayValuesOffsets(value);
        String encodedValues = TypeEncoder.encodeArrayValues(value);
        StringBuilder result = new StringBuilder();
        result.append(encodedLength);
        result.append(valuesOffsets);
        result.append(encodedValues);
        return result.toString();
    }

    private static <T extends Type> String encodeArrayValuesOffsets(DynamicArray<T> value) {
        boolean arrayOfDynamicArrays;
        StringBuilder result = new StringBuilder();
        boolean arrayOfBytes = !value.getValue().isEmpty() && value.getValue().get(0) instanceof DynamicBytes;
        boolean arrayOfString = !value.getValue().isEmpty() && value.getValue().get(0) instanceof Utf8String;
        boolean arrayOfDynamicStructs = !value.getValue().isEmpty() && value.getValue().get(0) instanceof DynamicStruct;
        boolean bl = arrayOfDynamicArrays = !value.getValue().isEmpty() && value.getValue().get(0) instanceof DynamicArray;
        if (arrayOfBytes || arrayOfString) {
            long offset = 0L;
            for (int i = 0; i < value.getValue().size(); ++i) {
                if (i == 0) {
                    offset = value.getValue().size() * 32;
                } else {
                    int bytesLength = arrayOfBytes ? ((byte[])((Type)value.getValue().get(i - 1)).getValue()).length : ((String)((Type)value.getValue().get(i - 1)).getValue()).length();
                    int numberOfWords = (bytesLength + 32 - 1) / 32;
                    int totalBytesLength = numberOfWords * 32;
                    offset += (long)(totalBytesLength + 32);
                }
                result.append(Numeric.toHexStringNoPrefix((byte[])Numeric.toBytesPadded((BigInteger)new BigInteger(Long.toString(offset)), (int)32)));
            }
        } else if (arrayOfDynamicArrays || arrayOfDynamicStructs) {
            result.append(TypeEncoder.encodeDynamicsTypesArraysOffsets(value));
        }
        return result.toString();
    }

    private static <T extends Type> String encodeDynamicsTypesArraysOffsets(Array<T> value) {
        StringBuilder result = new StringBuilder();
        long offset = value.getValue().size();
        List tailsEncoding = value.getValue().stream().map(TypeEncoder::encode).collect(Collectors.toList());
        for (int i = 0; i < value.getValue().size(); ++i) {
            offset = i == 0 ? (offset *= 32L) : (offset += (long)(((String)tailsEncoding.get(i - 1)).length() / 2));
            result.append(Numeric.toHexStringNoPrefix((byte[])Numeric.toBytesPadded((BigInteger)new BigInteger(Long.toString(offset)), (int)32)));
        }
        return result.toString();
    }

    private static <T extends Type> boolean isSupportingEncodedPacked(Array<T> value) {
        return !Utf8String.class.isAssignableFrom(value.getComponentType()) && !DynamicStruct.class.isAssignableFrom(value.getComponentType()) && !DynamicArray.class.isAssignableFrom(value.getComponentType()) && !StaticStruct.class.isAssignableFrom(value.getComponentType()) && !FixedPointType.class.isAssignableFrom(value.getComponentType()) && !DynamicBytes.class.isAssignableFrom(value.getComponentType());
    }

    private static <T extends Type> String arrayEncodePacked(Array<T> values) {
        if (TypeEncoder.isSupportingEncodedPacked(values)) {
            if (values.getValue().isEmpty()) {
                return "";
            }
            if (values instanceof DynamicArray) {
                return TypeEncoder.encode(values).substring(64);
            }
            if (values instanceof StaticArray) {
                return TypeEncoder.encode(values);
            }
        }
        throw new UnsupportedOperationException("Type cannot be packed encoded: " + String.valueOf(values.getClass()));
    }
}

