/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen.unit.gen;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

class CompilerClassLoader
extends ClassLoader {
    private final File outputDir;
    private final URL[] urls;

    CompilerClassLoader(File outputDir, URL ... urls) {
        super(CompilerClassLoader.class.getClassLoader());
        this.outputDir = outputDir;
        this.urls = urls;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.compileClass(name).flatMap(this::readBytes).map(bytes -> this.defineClass(name, (byte[])bytes, 0, ((byte[])bytes).length)).orElseThrow(() -> new ClassNotFoundException(name));
    }

    private Optional<File> compileClass(String name) {
        String path = name.replace(".", File.separator);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        File sourceFile = null;
        for (URL url : this.urls) {
            File file = new File(url.getFile(), path + ".java");
            if (!file.exists()) continue;
            sourceFile = file;
            break;
        }
        if (sourceFile == null) {
            sourceFile = new File(this.outputDir, path + ".java");
        }
        if (!sourceFile.exists()) {
            return Optional.empty();
        }
        Iterable<? extends JavaFileObject> javaFileObjects = compiler.getStandardFileManager(null, null, null).getJavaFileObjects(sourceFile);
        List<String> options = Arrays.asList("-d", this.outputDir.getAbsolutePath(), "-cp", this.buildClassPath());
        JavaCompiler.CompilationTask task = compiler.getTask(null, null, System.err::println, options, null, javaFileObjects);
        File classFile = new File(this.outputDir, path + ".class");
        return task.call() != false ? Optional.of(classFile) : Optional.empty();
    }

    private String buildClassPath() {
        return this.buildClassPath(this.urls) + ':' + System.getProperty("java.class.path");
    }

    private String buildClassPath(URL ... urls) {
        return Arrays.stream(urls).map(URL::toExternalForm).map(url -> url.replaceAll("file:", "")).collect(Collectors.joining(":"));
    }

    private Optional<byte[]> readBytes(File file) {
        try {
            return Optional.of(Files.readAllBytes(Paths.get(file.toURI())));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

