/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen.unit.gen;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.web3j.codegen.unit.gen.utills.MappingHelper;
import org.web3j.codegen.unit.gen.utills.NameUtils;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class ParserUtils {
    private static MappingHelper mappingHelper = new MappingHelper();

    static Object[] generatePlaceholderValues(Method method, Class contract) {
        Type returnType = ParserUtils.getMethodReturnType(method);
        Object[] source2 = ParserUtils.replaceTypeWithDefaultValue(method);
        Object[] source1 = returnType.equals(contract) ? new Object[]{NameUtils.toCamelCase(NameUtils.returnTypeAsLiteral(returnType, false)), returnType} : new Object[]{returnType, NameUtils.toCamelCase(NameUtils.returnTypeAsLiteral(returnType, true)), NameUtils.toCamelCase(contract)};
        return ParserUtils.mergePlaceholderValues(source1, source2);
    }

    private static Object[] replaceTypeWithDefaultValue(Method method) {
        return Arrays.stream(method.getParameterTypes()).map(ParserUtils::getDefaultValueForType).toArray();
    }

    private static Object getDefaultValueForType(Class type) {
        if (mappingHelper.getDefaultValueMap().containsKey(type)) {
            return mappingHelper.getDefaultValueMap().get(type);
        }
        return NameUtils.toCamelCase(type);
    }

    static String generateJavaPoetStringTypes(Method method, Class theContract) {
        StringBuilder symbolBuilder = new StringBuilder();
        if (ParserUtils.getMethodReturnType(method).equals(theContract)) {
            symbolBuilder.append("$L = $T.");
        } else {
            symbolBuilder.append("$T $L = $L.");
        }
        symbolBuilder.append(method.getName()).append("(").append(ParserUtils.getJavaPoetFormatSpecifier(method)).append(").send()");
        return symbolBuilder.toString();
    }

    private static String getJavaPoetFormatSpecifier(Method method) {
        ArrayList generated = new ArrayList();
        Arrays.asList(method.getParameterTypes()).forEach(type -> generated.add(mappingHelper.getJavaPoetFormat().getOrDefault(type, "$L")));
        return String.join((CharSequence)", ", generated);
    }

    static String generateAssertionJavaPoetStringTypes(Method method, Class theContract) {
        Type returnType = ParserUtils.getMethodReturnType(method);
        Object[] body = ParserUtils.generatePlaceholderValues(method, theContract);
        StringBuilder symbolBuilder = new StringBuilder();
        symbolBuilder.append("$T.");
        if (body[0].equals(TransactionReceipt.class)) {
            symbolBuilder.append("assertTrue($L.isStatusOK())");
        } else {
            symbolBuilder.append("assertEquals(");
            if (returnType.getTypeName().contains("Tuple")) {
                symbolBuilder.append("new $T(");
                for (Type t : ParserUtils.getTypeArray(returnType)) {
                    symbolBuilder.append(mappingHelper.getJavaPoetFormat().get(t)).append(", ");
                }
                symbolBuilder.deleteCharAt(symbolBuilder.lastIndexOf(", "));
                symbolBuilder.append(")");
            } else {
                symbolBuilder.append(mappingHelper.getJavaPoetFormat().get(body[0]));
            }
            symbolBuilder.append(", ");
            symbolBuilder.append("$L");
            symbolBuilder.append(")");
        }
        return symbolBuilder.toString();
    }

    static Object[] generateAssertionPlaceholderValues(Method method, Class contract) {
        Type returnType = ParserUtils.getMethodReturnType(method);
        Object[] body = ParserUtils.generatePlaceholderValues(method, contract);
        ArrayList<Object> placeHolder = new ArrayList<Object>();
        placeHolder.add(Assertions.class);
        if (body[0].equals(TransactionReceipt.class)) {
            placeHolder.add(NameUtils.toCamelCase(NameUtils.returnTypeAsLiteral(returnType, true)));
        } else {
            if (returnType.getTypeName().contains("Tuple")) {
                placeHolder.add(body[0]);
                for (Type t : ParserUtils.getTypeArray(returnType)) {
                    placeHolder.add(mappingHelper.getDefaultValueMap().get(t));
                }
            } else {
                placeHolder.add(mappingHelper.getDefaultValueMap().get(body[0]));
            }
            placeHolder.add(NameUtils.toCamelCase(NameUtils.returnTypeAsLiteral(returnType, true)));
        }
        return placeHolder.toArray();
    }

    static Type getMethodReturnType(Method method) {
        Type genericType = method.getGenericReturnType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            return parameterizedType.getActualTypeArguments()[0];
        }
        return genericType;
    }

    static Type[] getTypeArray(Type type) {
        ParameterizedType parameterizedType = (ParameterizedType)type;
        return parameterizedType.getActualTypeArguments();
    }

    private static Object[] mergePlaceholderValues(Object[] source1, Object[] source2) {
        Object[] destination = new Object[source1.length + source2.length];
        System.arraycopy(source1, 0, destination, 0, source1.length);
        System.arraycopy(source2, 0, destination, source1.length, source2.length);
        return destination;
    }
}

